"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverInvalidSelections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _options_list_selections = require("../../../common/options_list/options_list_selections");
var _use_field_formatter = require("../../hooks/use_field_formatter");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
var _options_list_strings = require("./options_list_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopoverInvalidSelections = () => {
  var _invalidSelections$le, _invalidSelections$le2;
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const fieldName = optionsList.select(state => state.explicitInput.fieldName);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const fieldSpec = optionsList.select(state => state.componentState.field);
  const dataViewId = optionsList.select(state => state.output.dataViewId);
  const fieldFormatter = (0, _use_field_formatter.useFieldFormatter)({
    dataViewId,
    fieldSpec
  });
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)([]); // will be set in following useEffect
  (0, _react.useEffect)(() => {
    /* This useEffect makes selectableOptions responsive to unchecking options */
    const options = (invalidSelections !== null && invalidSelections !== void 0 ? invalidSelections : []).map(key => {
      return {
        key: String(key),
        label: fieldFormatter(key),
        checked: 'on',
        className: 'optionsList__selectionInvalid',
        'data-test-subj': `optionsList-control-invalid-selection-${key}`,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("div", null, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionScreenReaderText(), '" "', " "))
      };
    });
    setSelectableOptions(options);
  }, [fieldFormatter, invalidSelections]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    className: "optionsList-control-ignored-selection-title",
    "data-test-subj": "optionList__invalidSelectionLabel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning",
    title: _options_list_strings.OptionsListStrings.popover.getInvalidSelectionScreenReaderText(),
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("label", null, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsSectionTitle((_invalidSelections$le = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.length) !== null && _invalidSelections$le !== void 0 ? _invalidSelections$le : 0))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsSectionAriaLabel(fieldName, (_invalidSelections$le2 = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.length) !== null && _invalidSelections$le2 !== void 0 ? _invalidSelections$le2 : 0),
    options: selectableOptions,
    listProps: {
      onFocusBadge: false,
      isVirtualized: false
    },
    onChange: (newSuggestions, _, changedOption) => {
      if (!fieldSpec || !changedOption.key) {
        // this should never happen, but early return for type safety
        // eslint-disable-next-line no-console
        console.warn(_options_list_strings.OptionsListStrings.popover.getInvalidSelectionMessage());
        return;
      }
      setSelectableOptions(newSuggestions);
      const key = (0, _options_list_selections.getSelectionAsFieldType)(fieldSpec, changedOption.key);
      optionsList.dispatch.deselectOption(key);
    }
  }, list => list));
};
exports.OptionsListPopoverInvalidSelections = OptionsListPopoverInvalidSelections;