"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopover = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
var _options_list_popover_footer = require("./options_list_popover_footer");
var _options_list_popover_action_bar = require("./options_list_popover_action_bar");
var _options_list_popover_suggestions = require("./options_list_popover_suggestions");
var _options_list_popover_invalid_selections = require("./options_list_popover_invalid_selections");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopover = ({
  isLoading,
  updateSearchString,
  loadMoreSuggestions
}) => {
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const field = optionsList.select(state => state.componentState.field);
  const availableOptions = optionsList.select(state => state.componentState.availableOptions);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const id = optionsList.select(state => state.explicitInput.id);
  const hideExclude = optionsList.select(state => state.explicitInput.hideExclude);
  const hideActionBar = optionsList.select(state => state.explicitInput.hideActionBar);
  const [showOnlySelected, setShowOnlySelected] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement("div", {
    id: `control-popover-${id}`,
    className: 'optionsList__popover',
    "data-test-subj": `optionsList-control-popover`
  }, (field === null || field === void 0 ? void 0 : field.type) !== 'boolean' && !hideActionBar && /*#__PURE__*/_react.default.createElement(_options_list_popover_action_bar.OptionsListPopoverActionBar, {
    showOnlySelected: showOnlySelected,
    updateSearchString: updateSearchString,
    setShowOnlySelected: setShowOnlySelected
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `optionsList-control-available-options`,
    "data-option-count": isLoading ? 0 : Object.keys(availableOptions !== null && availableOptions !== void 0 ? availableOptions : {}).length,
    style: {
      width: '100%',
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover_suggestions.OptionsListPopoverSuggestions, {
    loadMoreSuggestions: loadMoreSuggestions,
    showOnlySelected: showOnlySelected
  }), !showOnlySelected && invalidSelections && !(0, _lodash.isEmpty)(invalidSelections) && /*#__PURE__*/_react.default.createElement(_options_list_popover_invalid_selections.OptionsListPopoverInvalidSelections, null)), !hideExclude && /*#__PURE__*/_react.default.createElement(_options_list_popover_footer.OptionsListPopoverFooter, {
    isLoading: isLoading
  }));
};
exports.OptionsListPopover = OptionsListPopover;