"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListEditorOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _suggestions_searching = require("../../../common/options_list/suggestions_searching");
var _suggestions_sorting = require("../../../common/options_list/suggestions_sorting");
var _services = require("../../services");
var _options_list_strings = require("./options_list_strings");
var _control_setting_tooltip_label = require("../../components/control_setting_tooltip_label");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const selectionOptions = [{
  id: 'multi',
  label: _options_list_strings.OptionsListStrings.editor.selectionTypes.multi.getLabel(),
  'data-test-subj': 'optionsListControl__multiSearchOptionAdditionalSetting'
}, {
  id: 'single',
  label: _options_list_strings.OptionsListStrings.editor.selectionTypes.single.getLabel(),
  'data-test-subj': 'optionsListControl__singleSearchOptionAdditionalSetting'
}];
const allSearchOptions = [{
  id: 'prefix',
  label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.prefix.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.prefix.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__prefixSearchOptionAdditionalSetting'
}, {
  id: 'wildcard',
  label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.wildcard.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.wildcard.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__wildcardSearchOptionAdditionalSetting'
}, {
  id: 'exact',
  label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
    label: _options_list_strings.OptionsListStrings.editor.searchTypes.exact.getLabel(),
    tooltip: _options_list_strings.OptionsListStrings.editor.searchTypes.exact.getTooltip()
  }),
  'data-test-subj': 'optionsListControl__exactSearchOptionAdditionalSetting'
}];
const OptionsListEditorOptions = ({
  initialInput,
  onChange,
  fieldType
}) => {
  var _initialInput$sort$di, _initialInput$sort, _initialInput$sort$by, _initialInput$sort2;
  const [state, setState] = (0, _react.useState)({
    sortDirection: (_initialInput$sort$di = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$sort = initialInput.sort) === null || _initialInput$sort === void 0 ? void 0 : _initialInput$sort.direction) !== null && _initialInput$sort$di !== void 0 ? _initialInput$sort$di : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction,
    sortBy: (_initialInput$sort$by = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$sort2 = initialInput.sort) === null || _initialInput$sort2 === void 0 ? void 0 : _initialInput$sort2.by) !== null && _initialInput$sort$by !== void 0 ? _initialInput$sort$by : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by,
    searchTechnique: initialInput === null || initialInput === void 0 ? void 0 : initialInput.searchTechnique,
    runPastTimeout: initialInput === null || initialInput === void 0 ? void 0 : initialInput.runPastTimeout,
    singleSelect: initialInput === null || initialInput === void 0 ? void 0 : initialInput.singleSelect,
    hideExclude: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideExclude,
    hideExists: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideExists,
    hideSort: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideSort
  });
  const {
    loading: waitingForAllowExpensiveQueries,
    value: allowExpensiveQueries
  } = (0, _useAsync.default)(async () => {
    const {
      optionsList: optionsListService
    } = _services.pluginServices.getServices();
    return optionsListService.getAllowExpensiveQueries();
  }, []);
  const compatibleSearchTechniques = (0, _react.useMemo)(() => (0, _suggestions_searching.getCompatibleSearchTechniques)(fieldType), [fieldType]);
  const searchOptions = (0, _react.useMemo)(() => {
    return allSearchOptions.filter(searchOption => {
      return compatibleSearchTechniques.includes(searchOption.id);
    });
  }, [compatibleSearchTechniques]);
  (0, _react.useEffect)(() => {
    // when field type changes, ensure that the selected sort type is still valid
    if (!(0, _suggestions_sorting.getCompatibleSortingTypes)(fieldType).includes(state.sortBy)) {
      onChange({
        sort: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT
      });
      setState(s => ({
        ...s,
        sortBy: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by,
        sortDirection: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction
      }));
    }
  }, [fieldType, onChange, state.sortBy]);
  (0, _react.useEffect)(() => {
    // when field type changes, ensure that the selected search technique is still valid;
    // if the selected search technique **isn't** valid, reset to the default
    const searchTechnique = initialInput !== null && initialInput !== void 0 && initialInput.searchTechnique && compatibleSearchTechniques.includes(initialInput.searchTechnique) ? initialInput.searchTechnique : compatibleSearchTechniques[0];
    onChange({
      searchTechnique
    });
    setState(s => ({
      ...s,
      searchTechnique
    }));
  }, [compatibleSearchTechniques, onChange, initialInput]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getSelectionOptionsTitle(),
    "data-test-subj": "optionsListControl__selectionOptionsRadioGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: selectionOptions,
    idSelected: state.singleSelect ? 'single' : 'multi',
    onChange: id => {
      const newSingleSelect = id === 'single';
      onChange({
        singleSelect: newSingleSelect
      });
      setState(s => ({
        ...s,
        singleSelect: newSingleSelect
      }));
    }
  })), waitingForAllowExpensiveQueries ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  })) : allowExpensiveQueries && compatibleSearchTechniques.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getSearchOptionsTitle(),
    "data-test-subj": "optionsListControl__searchOptionsRadioGroup"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: searchOptions,
    idSelected: state.searchTechnique,
    onChange: id => {
      const searchTechnique = id;
      onChange({
        searchTechnique
      });
      setState(s => ({
        ...s,
        searchTechnique
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _options_list_strings.OptionsListStrings.editor.getAdditionalSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_control_setting_tooltip_label.ControlSettingTooltipLabel, {
      label: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTitle(),
      tooltip: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTooltip()
    }),
    checked: Boolean(state.runPastTimeout),
    onChange: () => {
      onChange({
        runPastTimeout: !state.runPastTimeout
      });
      setState(s => ({
        ...s,
        runPastTimeout: !s.runPastTimeout
      }));
    },
    "data-test-subj": 'optionsListControl__runPastTimeoutAdditionalSetting'
  })));
};
exports.OptionsListEditorOptions = OptionsListEditorOptions;