"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducersToIgnore = void 0;
exports.startDiffingControlGroupState = startDiffingControlGroupState;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _common = require("../../../common");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * An array of reducers which cannot cause unsaved changes. Unsaved changes only compares the explicit input
 * and the last saved input, so we can safely ignore any output reducers, and most componentState reducers.
 * This is only for performance reasons, because the diffing function itself can be quite heavy.
 */
const reducersToIgnore = exports.reducersToIgnore = ['setDefaultControlWidth', 'setDefaultControlGrow'];

/**
 * Does an initial diff between @param initialInput and @param initialLastSavedInput, and created a middleware
 * which listens to the redux store and checks for & publishes the unsaved changes on dispatches.
 */
function startDiffingControlGroupState() {
  const checkForUnsavedChangesSubject$ = new _rxjs.Subject();
  this.diffingSubscription.add(checkForUnsavedChangesSubject$.pipe((0, _rxjs.startWith)(null), (0, _rxjs.debounceTime)(_constants.CHANGE_CHECK_DEBOUNCE), (0, _rxjs.switchMap)(() => {
    return new _rxjs.Observable(observer => {
      var _lastSavedFilters$fil;
      if (observer.closed) return;
      const {
        explicitInput: currentInput,
        componentState: {
          lastSavedInput,
          lastSavedFilters
        },
        output: {
          filters,
          timeslice
        }
      } = this.getState();
      const hasUnsavedChanges = !((0, _common.persistableControlGroupInputIsEqual)(currentInput, lastSavedInput, false // never diff selections for unsaved changes - compare the output filters instead
      ) && (0, _esQuery.compareFilters)(filters !== null && filters !== void 0 ? filters : [], (_lastSavedFilters$fil = lastSavedFilters === null || lastSavedFilters === void 0 ? void 0 : lastSavedFilters.filters) !== null && _lastSavedFilters$fil !== void 0 ? _lastSavedFilters$fil : [], _esQuery.COMPARE_ALL_OPTIONS) && (0, _lodash.isEqual)(timeslice, lastSavedFilters === null || lastSavedFilters === void 0 ? void 0 : lastSavedFilters.timeslice));
      this.unsavedChanges.next(hasUnsavedChanges ? this.getPersistableInput() : undefined);
    });
  })).subscribe());
  const diffingMiddleware = store => next => action => {
    var _action$type$split;
    const dispatchedActionName = (_action$type$split = action.type.split('/')) === null || _action$type$split === void 0 ? void 0 : _action$type$split[1];
    if (dispatchedActionName && dispatchedActionName !== 'updateEmbeddableReduxOutput' &&
    // ignore any generic output updates.
    !reducersToIgnore.includes(dispatchedActionName)) {
      checkForUnsavedChangesSubject$.next(null);
    }
    next(action);
  };
  return diffingMiddleware;
}