"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupContainerFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _types = require("../types");
var _control_group_persistable_state = require("../../../common/control_group/control_group_persistable_state");
var _common = require("../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class ControlGroupContainerFactory {
  constructor(persistableStateService) {
    (0, _defineProperty2.default)(this, "isContainerType", true);
    (0, _defineProperty2.default)(this, "type", _types.CONTROL_GROUP_TYPE);
    (0, _defineProperty2.default)(this, "inject", void 0);
    (0, _defineProperty2.default)(this, "extract", void 0);
    (0, _defineProperty2.default)(this, "isEditable", async () => false);
    (0, _defineProperty2.default)(this, "getDisplayName", () => {
      return _i18n.i18n.translate('controls.controlGroup.title', {
        defaultMessage: 'Control group'
      });
    });
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent, initialComponentState, fieldFilterPredicate) => {
      const reduxEmbeddablePackage = await (0, _public.lazyLoadReduxToolsPackage)();
      const {
        ControlGroupContainer
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./control_group_container')));
      return new ControlGroupContainer(reduxEmbeddablePackage, initialInput, parent, initialComponentState, fieldFilterPredicate);
    });
    this.persistableStateService = persistableStateService;
    this.inject = (0, _control_group_persistable_state.createControlGroupInject)(this.persistableStateService);
    this.extract = (0, _control_group_persistable_state.createControlGroupExtract)(this.persistableStateService);
  }
  getDefaultInput() {
    return (0, _common.getDefaultControlGroupInput)();
  }
}
exports.ControlGroupContainerFactory = ControlGroupContainerFactory;