"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAddDataControlFlyout = openAddDataControlFlyout;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _ = require("../..");
var _control_group_constants = require("../../../common/control_group/control_group_constants");
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _control_group_container = require("../embeddable/control_group_container");
var _control_editor = require("./control_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function openAddDataControlFlyout(options) {
  var _this$getInput$defaul, _this$getInput$defaul2;
  const {
    controlInputTransform,
    onSave
  } = options || {};
  const {
    core: {
      theme,
      i18n
    },
    overlays: {
      openFlyout,
      openConfirm
    },
    controls: {
      getControlFactory
    }
  } = _services.pluginServices.getServices();
  const onCancel = changes => {
    if (!changes || Object.keys(changes.input).length === 0) {
      this.closeAllFlyouts();
      return;
    }
    openConfirm(_control_group_strings.ControlGroupStrings.management.discardNewControl.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.discardNewControl.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.discardNewControl.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.discardNewControl.getTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        this.closeAllFlyouts();
      }
    });
  };
  const onSaveFlyout = async (changes, type) => {
    this.closeAllFlyouts();
    if (!type) {
      return;
    }
    let controlInput = changes.input;
    const factory = getControlFactory(type);
    if (factory.presaveTransformFunction) {
      controlInput = factory.presaveTransformFunction(controlInput);
    }
    if (controlInputTransform) {
      controlInput = controlInputTransform({
        ...controlInput
      }, type);
    }
    const dataControlInput = {
      grow: changes.grow,
      width: changes.width,
      ...controlInput
    };
    let newControl;
    switch (type) {
      case _.OPTIONS_LIST_CONTROL:
        newControl = await this.addOptionsListControl(dataControlInput);
        break;
      case _.RANGE_SLIDER_CONTROL:
        newControl = await this.addRangeSliderControl(dataControlInput);
        break;
      default:
        newControl = await this.addDataControlFromField(dataControlInput);
    }
    if (onSave && !(0, _public.isErrorEmbeddable)(newControl)) {
      onSave(newControl.id);
    }
    (0, _reactRedux.batch)(() => {
      this.dispatch.setDefaultControlGrow(changes.grow);
      this.dispatch.setDefaultControlWidth(changes.width);
    });
  };
  const flyoutInstance = openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_control_group_container.ControlGroupContainerContext.Provider, {
    value: this
  }, /*#__PURE__*/_react.default.createElement(_control_editor.ControlEditor, {
    setLastUsedDataViewId: newId => this.setLastUsedDataViewId(newId),
    getRelevantDataViewId: this.getMostRelevantDataViewId,
    isCreate: true,
    width: (_this$getInput$defaul = this.getInput().defaultControlWidth) !== null && _this$getInput$defaul !== void 0 ? _this$getInput$defaul : _control_group_constants.DEFAULT_CONTROL_WIDTH,
    grow: (_this$getInput$defaul2 = this.getInput().defaultControlGrow) !== null && _this$getInput$defaul2 !== void 0 ? _this$getInput$defaul2 : _control_group_constants.DEFAULT_CONTROL_GROW,
    onSave: onSaveFlyout,
    onCancel: onCancel
  })), {
    theme,
    i18n
  }), {
    'aria-label': _control_group_strings.ControlGroupStrings.manageControl.getFlyoutCreateTitle(),
    outsideClickCloses: false,
    onClose: () => {
      onCancel();
    }
  });
  (0, _control_group_container.setFlyoutRef)(flyoutInstance);
}