"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlFrame = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _use_child_embeddable = require("../../hooks/use_child_embeddable");
var _control_group_container = require("../embeddable/control_group_container");
var _control_error_component = require("./control_error_component");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ControlFrame = ({
  customPrepend,
  enableActions,
  embeddableId,
  embeddableType
}) => {
  var _ref;
  const embeddableRoot = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createRef(), []);
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();
  const controlStyle = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.controlStyle);
  const viewMode = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.viewMode);
  const disabledActions = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.disabledActions);
  const embeddable = (0, _use_child_embeddable.useChildEmbeddable)({
    untilEmbeddableLoaded: controlGroup.untilEmbeddableLoaded.bind(controlGroup),
    embeddableType,
    embeddableId
  });
  const [title, setTitle] = (0, _react.useState)();
  const usingTwoLineLayout = controlStyle === 'twoLine';
  (0, _react.useEffect)(() => {
    let mounted = true;
    if (embeddableRoot.current) {
      embeddable === null || embeddable === void 0 ? void 0 : embeddable.render(embeddableRoot.current);
    }
    const inputSubscription = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput$().subscribe(newInput => {
      if (mounted) setTitle(newInput.title);
    });
    return () => {
      mounted = false;
      inputSubscription === null || inputSubscription === void 0 ? void 0 : inputSubscription.unsubscribe();
    };
  }, [embeddable, embeddableRoot]);
  const embeddableParentClassNames = (0, _classnames.default)('controlFrame__control', {
    'controlFrame--twoLine': controlStyle === 'twoLine',
    'controlFrame--oneLine': controlStyle === 'oneLine'
  });
  function renderEmbeddablePrepend() {
    if (typeof (embeddable === null || embeddable === void 0 ? void 0 : embeddable.renderPrepend) === 'function') {
      return embeddable.renderPrepend();
    }
    return usingTwoLineLayout ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "controlFrame__labelToolTip",
      content: title
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "controlFrame__formControlLayoutLabel",
      htmlFor: embeddableId
    }, title));
  }
  const form = /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    className: (0, _classnames.default)('controlFrame__formControlLayout', {
      'controlFrameFormControlLayout--twoLine': controlStyle === 'twoLine'
    }),
    fullWidth: true,
    prepend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_ref = embeddable && customPrepend) !== null && _ref !== void 0 ? _ref : null, renderEmbeddablePrepend())
  }, embeddable && /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableParentClassNames,
    id: `controlFrame--${embeddableId}`,
    ref: embeddableRoot
  }, (0, _public.isErrorEmbeddable)(embeddable) && /*#__PURE__*/_react.default.createElement(_control_error_component.ControlError, {
    error: embeddable.error
  })), !embeddable && /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableParentClassNames,
    id: `controlFrame--${embeddableId}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "controlFrame--controlLoading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null))));
  return /*#__PURE__*/_react.default.createElement(_public2.FloatingActions, {
    className: (0, _classnames.default)({
      'controlFrameFloatingActions--twoLine': usingTwoLineLayout,
      'controlFrameFloatingActions--oneLine': !usingTwoLineLayout
    }),
    viewMode: viewMode,
    api: embeddable,
    disabledActions: disabledActions,
    isEnabled: embeddable && enableActions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-frame-title",
    fullWidth: true,
    label: usingTwoLineLayout ? title || '...' : undefined
  }, form));
};
exports.ControlFrame = ControlFrame;