"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ControlError = ({
  error
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const errorMessage = error instanceof Error ? error.message : error;
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconSize: "m",
    iconType: "error",
    "data-test-subj": "control-frame-error",
    onClick: () => setPopoverOpen(open => !open),
    className: 'errorEmbeddableCompact__button',
    textProps: {
      className: 'errorEmbeddableCompact__text'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "controls.frame.error.message",
    defaultMessage: "An error occurred. View more"
  }));
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    className: "errorEmbeddableCompact__popover",
    closePopover: () => setPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    "data-test-subj": "errorMessageMarkdown",
    readOnly: true
  }, errorMessage)));
};
exports.ControlError = ControlError;