"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _ = require(".");
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isApiCompatible = api => Boolean((0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api.parentApi) && (0, _presentationPublishing.apiIsOfType)(api.parentApi, _types.CONTROL_GROUP_TYPE) && (0, _presentationContainers.apiIsPresentationContainer)(api.parentApi));
class DeleteControlAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _.ACTION_DELETE_CONTROL);
    (0, _defineProperty2.default)(this, "id", _.ACTION_DELETE_CONTROL);
    (0, _defineProperty2.default)(this, "order", 100);
    // should always be last
    (0, _defineProperty2.default)(this, "openConfirm", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      if (!isApiCompatible(context.embeddable)) throw new _public2.IncompatibleActionError();
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: this.getDisplayName(context)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `control-action-${context.embeddable.uuid}-delete`,
        "aria-label": this.getDisplayName(context),
        iconType: this.getIconType(context),
        onClick: () => this.execute(context),
        color: "danger"
      }));
    });
    ({
      overlays: {
        openConfirm: this.openConfirm
      }
    } = _services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return _control_group_strings.ControlGroupStrings.floatingActions.getRemoveButtonTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return 'trash';
  }
  async isCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable) && (0, _presentationPublishing.getInheritedViewMode)(embeddable.parentApi) === _public.ViewMode.EDIT;
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    this.openConfirm(_control_group_strings.ControlGroupStrings.management.deleteControls.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.deleteControls.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.deleteControls.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.deleteControls.getDeleteTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        embeddable.parentApi.removePanel(embeddable.uuid);
      }
    });
  }
}
exports.DeleteControlAction = DeleteControlAction;