"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.populateStorybookControlFactories = void 0;
var _options_list = require("../options_list");
var _range_slider = require("../range_slider");
var _time_slider = require("../time_slider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const populateStorybookControlFactories = controlsServiceStub => {
  const optionsListFactoryStub = new _options_list.OptionsListEmbeddableFactory();

  // cast to unknown because the stub cannot use the embeddable start contract to transform the EmbeddableFactoryDefinition into an EmbeddableFactory
  const optionsListControlFactory = optionsListFactoryStub;
  optionsListControlFactory.getDefaultInput = () => ({});
  controlsServiceStub.registerControlType(optionsListControlFactory);
  const rangeSliderFactoryStub = new _range_slider.RangeSliderEmbeddableFactory();

  // cast to unknown because the stub cannot use the embeddable start contract to transform the EmbeddableFactoryDefinition into an EmbeddableFactory
  const rangeSliderControlFactory = rangeSliderFactoryStub;
  rangeSliderControlFactory.getDefaultInput = () => ({});
  controlsServiceStub.registerControlType(rangeSliderControlFactory);
  const timesliderFactoryStub = new _time_slider.TimeSliderEmbeddableFactory();
  const timeSliderControlFactory = timesliderFactoryStub;
  timeSliderControlFactory.getDefaultInput = () => ({});
  controlsServiceStub.registerControlType(timeSliderControlFactory);
};
exports.populateStorybookControlFactories = populateStorybookControlFactories;