"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistableControlGroupInputKeys = exports.CONTROL_GROUP_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONTROL_GROUP_TYPE = exports.CONTROL_GROUP_TYPE = 'control_group';
/**
 * Only parts of the Control Group Input should be persisted
 */
const persistableControlGroupInputKeys = exports.persistableControlGroupInputKeys = ['panels', 'chainingSystem', 'controlStyle', 'ignoreParentSettings', 'showApplySelections'];

/**
 * Some use cases need the Persistable Control Group Input to conform to the SerializableRecord format which requires string index signatures in any objects
 */

// panels are json stringified for storage in a saved object.