"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMSearchClientFactory = exports.getContentClientFactory = void 0;
var _utils = require("../utils");
var _content_client = require("./content_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getContentClientFactory = ({
  contentRegistry
}) => contentTypeId => {
  const getForRequest = ({
    requestHandlerContext,
    version
  }) => {
    const contentDefinition = contentRegistry.getDefinition(contentTypeId);
    const storageContext = (0, _utils.getStorageContext)({
      contentTypeId,
      version: version !== null && version !== void 0 ? version : contentDefinition.version.latest,
      ctx: {
        contentRegistry,
        requestHandlerContext,
        getTransformsFactory: _utils.getServiceObjectTransformFactory
      }
    });
    const crudInstance = contentRegistry.getCrud(contentTypeId);
    return _content_client.ContentClient.create(contentTypeId, {
      storageContext,
      crudInstance
    });
  };
  return {
    /**
     * Client getter to interact with the registered content type.
     */
    getForRequest
  };
};
exports.getContentClientFactory = getContentClientFactory;
const getMSearchClientFactory = ({
  contentRegistry,
  mSearchService
}) => ({
  requestHandlerContext
}) => {
  const msearch = async ({
    contentTypes,
    query
  }) => {
    const contentTypesWithStorageContext = contentTypes.map(({
      contentTypeId,
      version
    }) => {
      const contentDefinition = contentRegistry.getDefinition(contentTypeId);
      const storageContext = (0, _utils.getStorageContext)({
        contentTypeId,
        version: version !== null && version !== void 0 ? version : contentDefinition.version.latest,
        ctx: {
          contentRegistry,
          requestHandlerContext,
          getTransformsFactory: _utils.getServiceObjectTransformFactory
        }
      });
      return {
        contentTypeId,
        ctx: storageContext
      };
    });
    const result = await mSearchService.search(contentTypesWithStorageContext, query);
    return {
      contentTypes,
      result
    };
  };
  return {
    msearch
  };
};
exports.getMSearchClientFactory = getMSearchClientFactory;