"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createQueryObservable = void 0;
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createQueryObservable = (queryClient, queryOptions) => {
  const queryObserver = new _reactQuery.QueryObserver(queryClient, queryClient.defaultQueryOptions(queryOptions));
  return new _rxjs.Observable(subscriber => {
    const unsubscribe = queryObserver.subscribe(
    // notifyManager is a singleton that batches updates across react query
    _reactQuery.notifyManager.batchCalls(result => {
      subscriber.next(result);
    }));
    return () => {
      unsubscribe();
    };
  });
};
exports.createQueryObservable = createQueryObservable;