"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateContentMutation = exports.useDeleteContentMutation = exports.useCreateContentMutation = void 0;
var _reactQuery = require("@tanstack/react-query");
var _content_client_context = require("./content_client_context");
var _content_client = require("./content_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useCreateContentMutation = () => {
  const contentClient = (0, _content_client_context.useContentClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: input => {
      return contentClient.create(input);
    },
    onSuccess: (data, variables) => {
      contentClient.queryClient.invalidateQueries({
        queryKey: _content_client.queryKeyBuilder.all(variables.contentTypeId)
      });
    }
  });
};
exports.useCreateContentMutation = useCreateContentMutation;
const useUpdateContentMutation = () => {
  const contentClient = (0, _content_client_context.useContentClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: input => {
      return contentClient.update(input);
    },
    onSuccess: (data, variables) => {
      contentClient.queryClient.invalidateQueries({
        queryKey: _content_client.queryKeyBuilder.all(variables.contentTypeId)
      });
    }
  });
};
exports.useUpdateContentMutation = useUpdateContentMutation;
const useDeleteContentMutation = () => {
  const contentClient = (0, _content_client_context.useContentClient)();
  return (0, _reactQuery.useMutation)({
    mutationFn: input => {
      return contentClient.delete(input);
    },
    onSuccess: (data, variables) => {
      contentClient.queryClient.invalidateQueries({
        queryKey: _content_client.queryKeyBuilder.all(variables.contentTypeId)
      });
    }
  });
};
exports.useDeleteContentMutation = useDeleteContentMutation;