"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryKeyBuilder = exports.ContentClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _reactQuery = require("@tanstack/react-query");
var _utils = require("@kbn/object-versioning/lib/utils");
var _query_observable = require("./query_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const queryKeyBuilder = exports.queryKeyBuilder = {
  all: type => [type],
  item: (type, id) => {
    return [...queryKeyBuilder.all(type), id];
  },
  search: (type, query, options) => {
    return [...queryKeyBuilder.all(type), 'search', query, options];
  }
};
const addVersion = (input, contentTypeRegistry) => {
  var _input$version;
  const contentType = contentTypeRegistry.get(input.contentTypeId);
  if (!contentType) {
    throw new Error(`Unknown content type [${input.contentTypeId}]`);
  }
  const version = (_input$version = input.version) !== null && _input$version !== void 0 ? _input$version : contentType.version.latest;
  const {
    result,
    value
  } = (0, _utils.validateVersion)(version);
  if (!result) {
    throw new Error(`Invalid version [${version}]. Must be an integer.`);
  }
  if (value > contentType.version.latest) {
    throw new Error(`Invalid version [${version}]. Latest version is [${contentType.version.latest}]`);
  }
  return {
    ...input,
    version
  };
};
const createQueryOptionBuilder = ({
  crudClientProvider,
  contentTypeRegistry
}) => {
  return {
    get: _input => {
      const input = addVersion(_input, contentTypeRegistry);
      return {
        queryKey: queryKeyBuilder.item(input.contentTypeId, input.id),
        queryFn: () => crudClientProvider(input.contentTypeId).get(input)
      };
    },
    search: _input => {
      const input = addVersion(_input, contentTypeRegistry);
      return {
        queryKey: queryKeyBuilder.search(input.contentTypeId, input.query, input.options),
        queryFn: () => crudClientProvider(input.contentTypeId).search(input)
      };
    }
  };
};
class ContentClient {
  constructor(crudClientProvider, contentTypeRegistry) {
    (0, _defineProperty2.default)(this, "queryClient", void 0);
    (0, _defineProperty2.default)(this, "queryOptionBuilder", void 0);
    this.crudClientProvider = crudClientProvider;
    this.contentTypeRegistry = contentTypeRegistry;
    this.queryClient = new _reactQuery.QueryClient({
      defaultOptions: {
        queries: {
          networkMode: 'always'
        }
      }
    });
    this.queryOptionBuilder = createQueryOptionBuilder({
      crudClientProvider: this.crudClientProvider,
      contentTypeRegistry: this.contentTypeRegistry
    });
  }
  get(input) {
    return this.queryClient.fetchQuery(this.queryOptionBuilder.get(input));
  }
  get$(input) {
    return (0, _query_observable.createQueryObservable)(this.queryClient, this.queryOptionBuilder.get(input));
  }
  create(input) {
    return this.crudClientProvider(input.contentTypeId).create(addVersion(input, this.contentTypeRegistry));
  }
  update(input) {
    return this.crudClientProvider(input.contentTypeId).update(addVersion(input, this.contentTypeRegistry));
  }
  delete(input) {
    return this.crudClientProvider(input.contentTypeId).delete(addVersion(input, this.contentTypeRegistry));
  }
  search(input) {
    return this.crudClientProvider(input.contentTypeId).search(addVersion(input, this.contentTypeRegistry));
  }
  search$(input) {
    return (0, _query_observable.createQueryObservable)(this.queryClient, this.queryOptionBuilder.search(addVersion(input, this.contentTypeRegistry)));
  }
  mSearch(input) {
    const crudClient = this.crudClientProvider();
    if (!crudClient.mSearch) {
      throw new Error('mSearch is not supported by provided crud client');
    }
    return crudClient.mSearch({
      ...input,
      contentTypes: input.contentTypes.map(contentType => addVersion(contentType, this.contentTypeRegistry))
    });
  }
}
exports.ContentClient = ContentClient;