"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSchemas = exports.getResultSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getResultSchema = exports.getResultSchema = _configSchema.schema.object({
  contentTypeId: _configSchema.schema.string(),
  result: _common.itemResultSchema
}, {
  unknowns: 'forbid'
});
const getSchemas = exports.getSchemas = {
  in: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    id: _configSchema.schema.string({
      minLength: 1
    }),
    version: _constants.versionSchema,
    options: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  }),
  out: getResultSchema
};