"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._test = void 0;
exports.getEndpointBodyCompleteComponents = getEndpointBodyCompleteComponents;
exports.getEndpointDescriptionByEndpoint = getEndpointDescriptionByEndpoint;
exports.getGlobalAutocompleteComponents = getGlobalAutocompleteComponents;
exports.getTopLevelUrlCompleteComponents = getTopLevelUrlCompleteComponents;
exports.getUnmatchedEndpointComponents = getUnmatchedEndpointComponents;
exports.loadActiveApi = loadActiveApi;
var _constants = require("../../../common/constants");
var _components = require("../autocomplete/components");
var _lodash = _interopRequireDefault(require("lodash"));
var _api = _interopRequireDefault(require("./api"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let ACTIVE_API = new _api.default();
let apiLoaded = false;
const isNotAnIndexName = name => name[0] === '_' && name !== '_all';
const parametrizedComponentFactories = {
  getComponent: function (name, parent, provideDefault) {
    if (this[name]) {
      return this[name];
    } else if (provideDefault) {
      return new _components.ListComponent(name, [], parent, false);
    }
  },
  index: function (name, parent) {
    if (isNotAnIndexName(name)) return;
    return new _components.IndexAutocompleteComponent(name, parent, true);
  },
  fields: function (name, parent) {
    return new _components.FieldAutocompleteComponent(name, parent, true);
  },
  field: function (name, parent) {
    return new _components.FieldAutocompleteComponent(name, parent, false);
  },
  // legacy index templates
  template: function (name, parent) {
    return new _components.LegacyTemplateAutocompleteComponent(name, parent);
  },
  // composable index templates
  // currently seems to be unused, but that is a useful functionality
  index_template: function (name, parent) {
    return new _components.IndexTemplateAutocompleteComponent(name, parent);
  },
  // currently seems to be unused, but that is a useful functionality
  component_template: function (name, parent) {
    return new _components.ComponentTemplateAutocompleteComponent(name, parent);
  },
  // currently seems to be unused, but that is a useful functionality
  data_stream: function (name, parent) {
    return new _components.DataStreamAutocompleteComponent(name, parent);
  }
};
function getUnmatchedEndpointComponents() {
  return ACTIVE_API.getUnmatchedEndpointComponents();
}
function getEndpointDescriptionByEndpoint(endpoint) {
  return ACTIVE_API.getEndpointDescriptionByEndpoint(endpoint);
}
function getEndpointBodyCompleteComponents(endpoint) {
  const desc = getEndpointDescriptionByEndpoint(endpoint);
  if (!desc) {
    throw new Error("failed to resolve endpoint ['" + endpoint + "']");
  }
  return desc.bodyAutocompleteRootComponents;
}
function getTopLevelUrlCompleteComponents(method) {
  return ACTIVE_API.getTopLevelUrlCompleteComponents(method);
}
function getGlobalAutocompleteComponents(term, throwOnMissing) {
  return ACTIVE_API.getGlobalAutocompleteComponents(term, throwOnMissing);
}
function loadApisFromJson(json, urlParametrizedComponentFactories, bodyParametrizedComponentFactories) {
  try {
    urlParametrizedComponentFactories = urlParametrizedComponentFactories || parametrizedComponentFactories;
    bodyParametrizedComponentFactories = bodyParametrizedComponentFactories || urlParametrizedComponentFactories;
    const api = new _api.default(urlParametrizedComponentFactories, bodyParametrizedComponentFactories);
    const names = [];
    _lodash.default.each(json, function (apiJson, name) {
      names.unshift(name);
      _lodash.default.each(apiJson.globals || {}, function (globalJson, globalName) {
        api.addGlobalAutocompleteRules(globalName, globalJson);
      });
      _lodash.default.each(apiJson.endpoints || {}, function (endpointJson, endpointName) {
        api.addEndpointDescription(endpointName, endpointJson);
      });
    });
    api.name = names.join(',');
    return api;
  } catch (e) {
    console.error(e);
  }
}
function setActiveApi(api) {
  if (!api) {
    return;
  }
  ACTIVE_API = api;
}
async function loadActiveApi(http) {
  // Only load the API data once
  if (apiLoaded) return;
  apiLoaded = true;
  try {
    const data = await http.get(`${_constants.API_BASE_PATH}/api_server`);
    setActiveApi(loadApisFromJson(data));
  } catch (err) {
    console.log(`failed to load API: ${err.responseText}`);
    // If we fail to load the API, clear this flag so it can be retried
    apiLoaded = false;
  }
}
const _test = exports._test = {
  loadApisFromJson: loadApisFromJson,
  setActiveApi: setActiveApi
};