"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _components = require("../autocomplete/components");
var _url_params = require("../autocomplete/url_params");
var _body_completer = require("../autocomplete/body_completer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 *
 * @param urlParametrizedComponentFactories a dictionary of factory functions
 * that will be used as fallback for parametrized path part (i.e., {index} )
 * see UrlPatternMatcher
 * @constructor
 * @param bodyParametrizedComponentFactories same as urlParametrizedComponentFactories but used for body compilation
 */
function Api(urlParametrizedComponentFactories, bodyParametrizedComponentFactories) {
  this.globalRules = Object.create(null);
  this.endpoints = Object.create(null);
  this.urlPatternMatcher = new _components.UrlPatternMatcher(urlParametrizedComponentFactories);
  this.globalBodyComponentFactories = bodyParametrizedComponentFactories;
  this.name = '';
}
(function (cls) {
  cls.addGlobalAutocompleteRules = function (parentNode, rules) {
    this.globalRules[parentNode] = (0, _body_completer.compileBodyDescription)('GLOBAL.' + parentNode, rules, this.globalBodyComponentFactories);
  };
  cls.getGlobalAutocompleteComponents = function (term, throwOnMissing) {
    const result = this.globalRules[term];
    if (_lodash.default.isUndefined(result) && (throwOnMissing || _lodash.default.isUndefined(throwOnMissing))) {
      throw new Error("failed to resolve global components for  ['" + term + "']");
    }
    return result;
  };
  cls.addEndpointDescription = function (endpoint, description) {
    const copiedDescription = {};
    _lodash.default.assign(copiedDescription, description || {});
    _lodash.default.defaults(copiedDescription, {
      id: endpoint,
      patterns: [endpoint],
      methods: ['GET']
    });
    _lodash.default.each(copiedDescription.patterns, p => {
      this.urlPatternMatcher.addEndpoint(p, copiedDescription);
    });
    copiedDescription.paramsAutocomplete = new _url_params.UrlParams(copiedDescription.url_params);
    copiedDescription.bodyAutocompleteRootComponents = (0, _body_completer.compileBodyDescription)(copiedDescription.id, copiedDescription.data_autocomplete_rules, this.globalBodyComponentFactories);
    this.endpoints[endpoint] = copiedDescription;
  };
  cls.getEndpointDescriptionByEndpoint = function (endpoint) {
    return this.endpoints[endpoint];
  };
  cls.getTopLevelUrlCompleteComponents = function (method) {
    return this.urlPatternMatcher.getTopLevelComponents(method);
  };
  cls.getUnmatchedEndpointComponents = function () {
    return (0, _body_completer.globalsOnlyAutocompleteComponents)();
  };
  cls.clear = function () {
    this.endpoints = {};
    this.globalRules = {};
  };
})(Api.prototype);
var _default = exports.default = Api;
module.exports = exports.default;