"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.looksLikeTypingIn = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var Move = /*#__PURE__*/function (Move) {
  Move[Move["ForwardOneCharacter"] = 1] = "ForwardOneCharacter";
  Move[Move["ForwardOneToken"] = 2] = "ForwardOneToken";
  Move[Move["ForwardTwoTokens"] = 3] = "ForwardTwoTokens";
  return Move;
}(Move || {}); // the column position could jump two tokens due to autocomplete
const knownTypingInTokenTypes = new Map([[Move.ForwardOneCharacter, new Map([
// a pair of the last evaluated token type and a set of the current token types
['', new Set(['method'])], ['url.amp', new Set(['url.param'])], ['url.comma', new Set(['url.part', 'url.questionmark'])], ['url.equal', new Set(['url.value'])], ['url.param', new Set(['url.amp', 'url.equal'])], ['url.questionmark', new Set(['url.param'])], ['url.slash', new Set(['url.part', 'url.questionmark'])], ['url.value', new Set(['url.amp'])]])], [Move.ForwardOneToken, new Map([['method', new Set(['url.part'])], ['url.amp', new Set(['url.amp', 'url.equal'])], ['url.comma', new Set(['url.comma', 'url.questionmark', 'url.slash'])], ['url.equal', new Set(['url.amp'])], ['url.param', new Set(['url.equal'])], ['url.part', new Set(['url.comma', 'url.questionmark', 'url.slash'])], ['url.questionmark', new Set(['url.equal'])], ['url.slash', new Set(['url.comma', 'url.questionmark', 'url.slash'])], ['url.value', new Set(['url.amp'])], ['whitespace', new Set(['url.comma', 'url.questionmark', 'url.slash'])]])], [Move.ForwardTwoTokens, new Map([['url.part', new Set(['url.param', 'url.part'])]])]]);
const getOneCharacterNextOnTheRight = (pos, coreEditor) => {
  const range = {
    start: {
      column: pos.column + 1,
      lineNumber: pos.lineNumber
    },
    end: {
      column: pos.column + 2,
      lineNumber: pos.lineNumber
    }
  };
  return coreEditor.getValueInRange(range);
};

/**
 * Examines a change from the last evaluated to the current token and one
 * character next to the current token position on the right. Returns true if
 * the change looks like typing in, false otherwise.
 *
 * This function is supposed to filter out situations where autocomplete is not
 * preferable, such as clicking around the editor, navigating the editor via
 * keyboard arrow keys, etc.
 */
const looksLikeTypingIn = (lastEvaluatedToken, currentToken, coreEditor) => {
  // if the column position moves to the right in the same line and the current
  // token length is 1, then user is possibly typing in a character.
  if (lastEvaluatedToken.position.column < currentToken.position.column && lastEvaluatedToken.position.lineNumber === currentToken.position.lineNumber && currentToken.value.length === 1 && getOneCharacterNextOnTheRight(currentToken.position, coreEditor) === '') {
    const moves = lastEvaluatedToken.position.column + 1 === currentToken.position.column ? [Move.ForwardOneCharacter] : [Move.ForwardOneToken, Move.ForwardTwoTokens];
    for (const move of moves) {
      var _knownTypingInTokenTy, _tokenTypesPairs$get;
      const tokenTypesPairs = (_knownTypingInTokenTy = knownTypingInTokenTypes.get(move)) !== null && _knownTypingInTokenTy !== void 0 ? _knownTypingInTokenTy : new Map();
      const currentTokenTypes = (_tokenTypesPairs$get = tokenTypesPairs.get(lastEvaluatedToken.type)) !== null && _tokenTypesPairs$get !== void 0 ? _tokenTypesPairs$get : new Set();
      if (currentTokenTypes.has(currentToken.type)) {
        return true;
      }
    }
  }

  // if the column or the line number have changed for the last token or
  // user did not provided a new value, then we should not show autocomplete
  // this guards against triggering autocomplete when clicking around the editor
  if (lastEvaluatedToken.position.column !== currentToken.position.column || lastEvaluatedToken.position.lineNumber !== currentToken.position.lineNumber || lastEvaluatedToken.value === currentToken.value) {
    return false;
  }
  return true;
};
exports.looksLikeTypingIn = looksLikeTypingIn;