"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEndpointFromPosition = getEndpointFromPosition;
var _autocomplete = require("./autocomplete");
var _kb = require("../kb/kb");
var _engine = require("./engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getEndpointFromPosition(editor, pos, parser) {
  const lineValue = editor.getLineValue(pos.lineNumber);
  const context = {
    ...(0, _autocomplete.getCurrentMethodAndTokenPaths)(editor, {
      column: lineValue.length + 1 /* Go to the very end of the line */,
      lineNumber: pos.lineNumber
    }, parser, true)
  };
  const components = (0, _kb.getTopLevelUrlCompleteComponents)(context.method);
  (0, _engine.populateContext)(context.urlTokenPath, context, editor, true, components);
  return context.endpoint;
}