"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptMode = void 0;
var _brace = _interopRequireDefault(require("brace"));
var _ace = require("@kbn/ace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TextMode = _brace.default.acequire('ace/mode/text').Mode;
const MatchingBraceOutdent = _brace.default.acequire('ace/mode/matching_brace_outdent').MatchingBraceOutdent;
const CstyleBehaviour = _brace.default.acequire('ace/mode/behaviour/cstyle').CstyleBehaviour;
const CStyleFoldMode = _brace.default.acequire('ace/mode/folding/cstyle').FoldMode;
_brace.default.acequire('ace/tokenizer');
class ScriptMode extends TextMode {
  constructor() {
    super();
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CstyleBehaviour();
    this.foldingRules = new CStyleFoldMode();
  }
}
exports.ScriptMode = ScriptMode;
(function () {
  this.HighlightRules = _ace.ScriptHighlightRules;
  this.getNextLineIndent = function (state, line, tab) {
    let indent = this.$getIndent(line);
    const match = line.match(/^.*[\{\[]\s*$/);
    if (match) {
      indent += tab;
    }
    return indent;
  };
  this.checkOutdent = function (state, line, input) {
    return this.$outdent.checkOutdent(line, input);
  };
  this.autoOutdent = function (state, doc, row) {
    this.$outdent.autoOutdent(doc, row);
  };
}).call(ScriptMode.prototype);