"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetInputEditor = void 0;
var _react = require("react");
var _editor_context = require("../contexts/editor_context");
var _editor_registry = require("../contexts/editor_context/editor_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useSetInputEditor = () => {
  const dispatch = (0, _editor_context.useEditorActionContext)();
  return (0, _react.useCallback)(editor => {
    dispatch({
      type: 'setInputEditor',
      payload: editor
    });
    _editor_registry.instance.setInputEditor(editor);
  }, [dispatch]);
};
exports.useSetInputEditor = useSetInputEditor;