"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.restoreRequestFromHistoryToMonaco = restoreRequestFromHistoryToMonaco;
var _utils = require("../../../lib/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function restoreRequestFromHistoryToMonaco(provider, req) {
  let s = req.method + ' ' + req.endpoint;
  if (req.data) {
    const indent = true;
    const formattedData = (0, _utils.formatRequestBodyDoc)([req.data], indent);
    s += '\n' + formattedData.data;
  }
  await provider.restoreRequestFromHistory(s);
}