"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateToTextObjects = migrateToTextObjects;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Once off migration to new text object data structure
 */
async function migrateToTextObjects({
  history,
  objectStorageClient: objectStorageClient
}) {
  const legacyTextContent = history.getLegacySavedEditorState();
  if (!legacyTextContent) return;
  await objectStorageClient.text.create({
    createdAt: Date.now(),
    updatedAt: Date.now(),
    text: legacyTextContent.content
  });
  history.deleteLegacySavedEditorState();
}