"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Main = Main;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _console_history = require("../console_history");
var _editor = require("../editor");
var _settings = require("../settings");
var _variables = require("../variables");
var _components = require("../../components");
var _contexts = require("../../contexts");
var _hooks = require("../../hooks");
var _get_top_nav = require("./get_top_nav");
var _utils = require("../../../lib/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Main({
  hideWelcome = false
}) {
  var _getResponseWithMostS;
  const {
    services: {
      storage
    }
  } = (0, _contexts.useServicesContext)();
  const {
    ready: editorsReady
  } = (0, _contexts.useEditorReadContext)();
  const {
    requestInFlight: requestInProgress,
    lastResult: {
      data: requestData,
      error: requestError
    }
  } = (0, _contexts.useRequestReadContext)();
  const [showWelcome, setShowWelcomePanel] = (0, _react.useState)(() => storage.get('version_welcome_shown') !== '@@SENSE_REVISION' && !hideWelcome);
  const [showingHistory, setShowHistory] = (0, _react.useState)(false);
  const [showSettings, setShowSettings] = (0, _react.useState)(false);
  const [showHelp, setShowHelp] = (0, _react.useState)(false);
  const [showVariables, setShowVariables] = (0, _react.useState)(false);
  const [editorInstance, setEditorInstance] = (0, _react.useState)(null);
  const renderConsoleHistory = () => {
    return editorsReady ? /*#__PURE__*/_react.default.createElement(_console_history.ConsoleHistory, {
      close: () => setShowHistory(false)
    }) : null;
  };
  const {
    done,
    error,
    retry
  } = (0, _hooks.useDataInit)();
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_components.SomethingWentWrongCallout, {
      onButtonClick: retry,
      error: error
    }));
  }
  const data = (_getResponseWithMostS = (0, _utils.getResponseWithMostSevereStatusCode)(requestData)) !== null && _getResponseWithMostS !== void 0 ? _getResponseWithMostS : requestError;
  return /*#__PURE__*/_react.default.createElement("div", {
    id: "consoleRoot"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "consoleContainer",
    gutterSize: "none",
    direction: "column",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "euiScreenReaderOnly"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('console.pageHeading', {
    defaultMessage: 'Console'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.TopNavMenu, {
    disabled: !done,
    items: (0, _get_top_nav.getTopNavConfig)({
      onClickHistory: () => setShowHistory(!showingHistory),
      onClickSettings: () => setShowSettings(true),
      onClickHelp: () => setShowHelp(!showHelp),
      onClickVariables: () => setShowVariables(!showVariables)
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "conApp__tabsExtension"
  }, /*#__PURE__*/_react.default.createElement(_components.NetworkRequestStatusBar, {
    requestInProgress: requestInProgress,
    requestResult: data ? {
      method: data.request.method.toUpperCase(),
      endpoint: data.request.path,
      statusCode: data.response.statusCode,
      statusText: data.response.statusText,
      timeElapsedMs: data.response.timeMs
    } : undefined
  })))), showingHistory ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderConsoleHistory()) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_editor.Editor, {
    loading: !done,
    setEditorInstance: setEditorInstance
  }))), done && showWelcome ? /*#__PURE__*/_react.default.createElement(_components.WelcomePanel, {
    onDismiss: () => {
      storage.set('version_welcome_shown', '@@SENSE_REVISION');
      setShowWelcomePanel(false);
    }
  }) : null, showSettings ? /*#__PURE__*/_react.default.createElement(_settings.Settings, {
    onClose: () => setShowSettings(false),
    editorInstance: editorInstance
  }) : null, showVariables ? /*#__PURE__*/_react.default.createElement(_variables.Variables, {
    onClose: () => setShowVariables(false)
  }) : null, showHelp ? /*#__PURE__*/_react.default.createElement(_components.HelpPanel, {
    onClose: () => setShowHelp(false)
  }) : null);
}