"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whitespacesRegex = exports.variableTemplateRegex = exports.slashRegex = exports.questionMarkRegex = exports.propertyValueRegex = exports.propertyNameRegex = exports.numberStartRegex = exports.newLineRegex = exports.methodWithUrlRegex = exports.methodWhitespaceRegex = exports.lettersRegex = exports.i18nTexts = exports.equalsSignRegex = exports.digitRegex = exports.ampersandRegex = exports.SELECTED_REQUESTS_CLASSNAME = exports.END_OF_URL_TOKEN = exports.AutocompleteType = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * CSS class name used for the styling of highlighted requests
 */
const SELECTED_REQUESTS_CLASSNAME = exports.SELECTED_REQUESTS_CLASSNAME = 'console__monaco_editor__selectedRequests';
const whitespacesRegex = exports.whitespacesRegex = /\s+/;
const newLineRegex = exports.newLineRegex = /\n/;
const slashRegex = exports.slashRegex = /\//;
const ampersandRegex = exports.ampersandRegex = /&/;
const equalsSignRegex = exports.equalsSignRegex = /=/;
const questionMarkRegex = exports.questionMarkRegex = /\?/;
const variableTemplateRegex = exports.variableTemplateRegex = /\${(\w+)}/g;
const numberStartRegex = exports.numberStartRegex = /[-\d]/;
const digitRegex = exports.digitRegex = /[\d]/;
const lettersRegex = exports.lettersRegex = /[A-Za-z]/;
const END_OF_URL_TOKEN = exports.END_OF_URL_TOKEN = '__url_path_end__';

/*
 * This regex matches a string that has a method with a whitespace after it, for example "GET ".
 * In this case autocomplete suggestions should be triggered for an url.
 */
const methodWhitespaceRegex = exports.methodWhitespaceRegex = /^\s*(GET|POST|PUT|PATCH|DELETE)\s+$/i;
/*
 * This regex matches a string that has
 * a method and some parts of an url ending with a slash, a question mark or an equals sign,
 * for example "GET _search/", "GET _search?", "GET _search?param=".
 * In this case autocomplete suggestions should be triggered for an url part or param.
 */
const methodWithUrlRegex = exports.methodWithUrlRegex = /^\s*(GET|POST|PUT|PATCH|DELETE)\s+[a-z0-9\/._\-?=&]*[?=\/]$/i;
/*
 * This regex matches a string that has
 * optional whitespace characters and a double quote, for example `  "`.
 * In this case autocomplete suggestions should be triggered for a property name.
 */
const propertyNameRegex = exports.propertyNameRegex = /^\s*"$/;
/*
 * This regex matches a string that has
 * a property name, a colon and an optional double quote, for example `"query" : "`.
 * In this case autocomplete suggestions should be triggered for a property value.
 */
const propertyValueRegex = exports.propertyValueRegex = /^\s*"[a-zA-Z0-9_]+"\s*:\s*"?$/;

/*
 * i18n for autocomplete labels
 */
const i18nTexts = exports.i18nTexts = {
  method: _i18n.i18n.translate('console.autocompleteSuggestions.methodLabel', {
    defaultMessage: 'method'
  }),
  endpoint: _i18n.i18n.translate('console.autocompleteSuggestions.endpointLabel', {
    defaultMessage: 'endpoint'
  }),
  param: _i18n.i18n.translate('console.autocompleteSuggestions.paramLabel', {
    defaultMessage: 'param'
  }),
  api: _i18n.i18n.translate('console.autocompleteSuggestions.apiLabel', {
    defaultMessage: 'API'
  })
};
let AutocompleteType = exports.AutocompleteType = /*#__PURE__*/function (AutocompleteType) {
  AutocompleteType["PATH"] = "path";
  AutocompleteType["URL_PARAMS"] = "url_params";
  AutocompleteType["METHOD"] = "method";
  AutocompleteType["BODY"] = "body";
  return AutocompleteType;
}({});