"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuggestionProvider = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getSuggestionProvider = actionsProvider => {
  return {
    // force suggestions when these characters are used
    triggerCharacters: ['/', '.', '_', ',', '?', '=', '&', '"'],
    provideCompletionItems: (...args) => {
      if (actionsProvider.current) {
        var _actionsProvider$curr;
        return (_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.provideCompletionItems(...args);
      }
      return {
        suggestions: []
      };
    }
  };
};
exports.getSuggestionProvider = getSuggestionProvider;