"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonacoEditorOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _react2 = require("@emotion/react");
var _vectorTile = require("@mapbox/vector-tile");
var _pbf = _interopRequireDefault(require("pbf"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _contexts = require("../../../contexts");
var _mapbox_vector_tile = require("../legacy/console_editor/mapbox_vector_tile");
var _utilities = require("../utilities");
var _hooks = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MonacoEditorOutput = () => {
  const {
    settings: readOnlySettings
  } = (0, _contexts.useEditorReadContext)();
  const {
    lastResult: {
      data
    }
  } = (0, _contexts.useRequestReadContext)();
  const [value, setValue] = (0, _react.useState)('');
  const [mode, setMode] = (0, _react.useState)('text');
  const divRef = (0, _react.useRef)(null);
  const {
    setupResizeChecker,
    destroyResizeChecker
  } = (0, _hooks.useResizeCheckerUtils)();
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    setupResizeChecker(divRef.current, editor);
  }, [setupResizeChecker]);
  const editorWillUnmountCallback = (0, _react.useCallback)(() => {
    destroyResizeChecker();
  }, [destroyResizeChecker]);
  (0, _react.useEffect)(() => {
    if (data) {
      const isMultipleRequest = data.length > 1;
      setMode(isMultipleRequest ? _monaco.CONSOLE_OUTPUT_LANG_ID : (0, _utilities.languageForContentType)(data[0].response.contentType));
      setValue(data.map(result => {
        const {
          value: newValue,
          contentType
        } = result.response;
        let editorOutput;
        if (readOnlySettings.tripleQuotes && (0, _utilities.isJSONContentType)(contentType)) {
          editorOutput = (0, _utilities.safeExpandLiteralStrings)(newValue);
        } else if ((0, _utilities.isMapboxVectorTile)(contentType)) {
          const vectorTile = new _vectorTile.VectorTile(new _pbf.default(newValue));
          const vectorTileJson = (0, _mapbox_vector_tile.convertMapboxVectorTileToJson)(vectorTile);
          editorOutput = (0, _utilities.safeExpandLiteralStrings)(vectorTileJson);
        } else {
          editorOutput = newValue;
        }
        return editorOutput;
      }).join('\n'));
    } else {
      setValue('');
    }
  }, [readOnlySettings, data, value]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
      `,
    ref: divRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: 'ConAppOutputTextarea'
  }, _i18n.i18n.translate('console.outputTextarea', {
    defaultMessage: 'Dev Tools Console output'
  }))), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: 'consoleMonacoOutput',
    languageId: mode,
    value: value,
    fullWidth: true,
    editorDidMount: editorDidMountCallback,
    editorWillUnmount: editorWillUnmountCallback,
    options: {
      readOnly: true,
      fontSize: readOnlySettings.fontSize,
      wordWrap: readOnlySettings.wrapMode === true ? 'on' : 'off',
      theme: _monaco.CONSOLE_THEME_ID,
      automaticLayout: true
    }
  }));
};
exports.MonacoEditorOutput = MonacoEditorOutput;