"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonacoEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _contexts = require("../../../contexts");
var _hooks2 = require("./hooks");
var _monaco_editor_actions_provider = require("./monaco_editor_actions_provider");
var _monaco_editor_suggestion_provider = require("./monaco_editor_suggestion_provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const MonacoEditor = ({
  initialTextValue
}) => {
  const context = (0, _contexts.useServicesContext)();
  const {
    services: {
      notifications,
      esHostService,
      settings: settingsService,
      autocompleteInfo
    },
    docLinkVersion
  } = context;
  const {
    toasts
  } = notifications;
  const {
    settings
  } = (0, _contexts.useEditorReadContext)();
  const divRef = (0, _react.useRef)(null);
  const {
    setupResizeChecker,
    destroyResizeChecker
  } = (0, _hooks2.useResizeCheckerUtils)();
  const {
    registerKeyboardCommands,
    unregisterKeyboardCommands
  } = (0, _hooks2.useKeyboardCommandsUtils)();
  const dispatch = (0, _contexts.useRequestActionContext)();
  const actionsProvider = (0, _react.useRef)(null);
  const [editorActionsCss, setEditorActionsCss] = (0, _react.useState)({});
  const setInputEditor = (0, _hooks.useSetInputEditor)();
  const getCurlCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr;
    const curl = await ((_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.getCurl(esHostService.getHost()));
    return curl !== null && curl !== void 0 ? curl : '';
  }, [esHostService]);
  const getDocumenationLink = (0, _react.useCallback)(async () => {
    return actionsProvider.current.getDocumentationLink(docLinkVersion);
  }, [docLinkVersion]);
  const autoIndentCallback = (0, _react.useCallback)(async () => {
    return actionsProvider.current.autoIndent();
  }, []);
  const sendRequestsCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr2;
    await ((_actionsProvider$curr2 = actionsProvider.current) === null || _actionsProvider$curr2 === void 0 ? void 0 : _actionsProvider$curr2.sendRequests(dispatch, context));
  }, [dispatch, context]);
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    const provider = new _monaco_editor_actions_provider.MonacoEditorActionsProvider(editor, setEditorActionsCss);
    setInputEditor(provider);
    actionsProvider.current = provider;
    setupResizeChecker(divRef.current, editor);
    registerKeyboardCommands({
      editor,
      sendRequest: sendRequestsCallback,
      autoIndent: async () => {
        var _actionsProvider$curr3;
        return await ((_actionsProvider$curr3 = actionsProvider.current) === null || _actionsProvider$curr3 === void 0 ? void 0 : _actionsProvider$curr3.autoIndent());
      },
      getDocumentationLink: getDocumenationLink,
      moveToPreviousRequestEdge: async () => {
        var _actionsProvider$curr4;
        return await ((_actionsProvider$curr4 = actionsProvider.current) === null || _actionsProvider$curr4 === void 0 ? void 0 : _actionsProvider$curr4.moveToPreviousRequestEdge());
      },
      moveToNextRequestEdge: async () => {
        var _actionsProvider$curr5;
        return await ((_actionsProvider$curr5 = actionsProvider.current) === null || _actionsProvider$curr5 === void 0 ? void 0 : _actionsProvider$curr5.moveToNextRequestEdge());
      }
    });
  }, [getDocumenationLink, registerKeyboardCommands, sendRequestsCallback, setupResizeChecker, setInputEditor]);
  const editorWillUnmountCallback = (0, _react.useCallback)(() => {
    destroyResizeChecker();
    unregisterKeyboardCommands();
  }, [destroyResizeChecker, unregisterKeyboardCommands]);
  const suggestionProvider = (0, _react.useMemo)(() => {
    return (0, _monaco_editor_suggestion_provider.getSuggestionProvider)(actionsProvider);
  }, []);
  const [value, setValue] = (0, _react.useState)(initialTextValue);
  (0, _hooks2.useSetInitialValue)({
    initialTextValue,
    setValue,
    toasts
  });
  (0, _hooks2.useSetupAutocompletePolling)({
    autocompleteInfo,
    settingsService
  });
  (0, _hooks2.useSetupAutosave)({
    value
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
      `,
    ref: divRef,
    "data-test-subj": "consoleMonacoEditorContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "conApp__editorActions",
    id: "ConAppEditorActions",
    gutterSize: "none",
    responsive: false,
    style: editorActionsCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('console.sendRequestButtonTooltipContent', {
      defaultMessage: 'Click to send request'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    color: "primary",
    onClick: sendRequestsCallback,
    "data-test-subj": "sendRequestButton",
    "aria-label": _i18n.i18n.translate('console.sendRequestButtonTooltipAriaLabel', {
      defaultMessage: 'Click to send request'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "play"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.ConsoleMenu, {
    getCurl: getCurlCallback,
    getDocumentation: getDocumenationLink,
    autoIndent: autoIndentCallback,
    notifications: notifications
  }))), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: 'consoleMonacoEditor',
    languageId: _monaco.CONSOLE_LANG_ID,
    value: value,
    onChange: setValue,
    fullWidth: true,
    accessibilityOverlayEnabled: settings.isAccessibilityOverlayEnabled,
    editorDidMount: editorDidMountCallback,
    editorWillUnmount: editorWillUnmountCallback,
    options: {
      fontSize: settings.fontSize,
      wordWrap: settings.wrapMode === true ? 'on' : 'off',
      theme: _monaco.CONSOLE_THEME_ID
    },
    suggestionProvider: suggestionProvider
  }));
};
exports.MonacoEditor = MonacoEditor;