"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetupAutosave = void 0;
var _react = require("react");
var _hooks = require("../../../../hooks");
var _use_set_initial_value = require("./use_set_initial_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Hook that sets up autosaving the Console editor input to localStorage.
 *
 * @param params The {@link SetupAutosaveParams} to use.
 */
const useSetupAutosave = params => {
  const {
    value
  } = params;
  const saveCurrentTextObject = (0, _hooks.useSaveCurrentTextObject)();
  const timerRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    function saveCurrentState() {
      try {
        saveCurrentTextObject(value);
      } catch (e) {
        // Ignoring saving error
      }
    }
    const saveDelay = 500;
    if (timerRef.current) {
      clearTimeout(timerRef.current);
    }
    const loadFromParam = (0, _use_set_initial_value.readLoadFromParam)();
    if (loadFromParam) {
      // If we pre-loaded content we want to skip saving the state of the editor
      return;
    }
    timerRef.current = window.setTimeout(saveCurrentState, saveDelay);
    return () => {
      if (timerRef.current) {
        clearTimeout(timerRef.current);
      }
    };
  }, [saveCurrentTextObject, value]);
};
exports.useSetupAutosave = useSetupAutosave;