"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSetupAutocompletePolling = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Hook that sets up the autocomplete polling for Console editor.
 *
 * @param params The {@link SetupAutocompletePollingParams} to use.
 */
const useSetupAutocompletePolling = params => {
  const {
    autocompleteInfo,
    settingsService
  } = params;
  (0, _react.useEffect)(() => {
    autocompleteInfo.retrieve(settingsService, settingsService.getAutocomplete());
    return () => {
      autocompleteInfo.clearSubscriptions();
    };
  }, [autocompleteInfo, settingsService]);
};
exports.useSetupAutocompletePolling = useSetupAutocompletePolling;