"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autoIndent = autoIndent;
exports.getDocumentation = getDocumentation;
var _get_endpoint_from_position = require("../../../../lib/autocomplete/get_endpoint_from_position");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function autoIndent(editor, event) {
  event.preventDefault();
  await editor.autoIndent();
  editor.getCoreEditor().getContainer().focus();
}
function getDocumentation(editor, docLinkVersion) {
  return editor.getRequestsInRange().then(requests => {
    if (!requests || requests.length === 0) {
      return null;
    }
    const position = requests[0].range.end;
    position.column = position.column - 1;
    const endpoint = (0, _get_endpoint_from_position.getEndpointFromPosition)(editor.getCoreEditor(), position, editor.parser);
    if (endpoint && endpoint.documentation && endpoint.documentation.indexOf('http') !== -1) {
      return endpoint.documentation.replace('/master/', `/${docLinkVersion}/`).replace('/current/', `/${docLinkVersion}/`).replace('/{branch}/', `/${docLinkVersion}/`);
    } else {
      return null;
    }
  });
}