"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCommands = registerCommands;
exports.unregisterCommands = unregisterCommands;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const COMMANDS = {
  SEND_TO_ELASTICSEARCH: 'send to Elasticsearch',
  OPEN_DOCUMENTATION: 'open documentation',
  AUTO_INDENT_REQUEST: 'auto indent request',
  MOVE_TO_PREVIOUS_REQUEST: 'move to previous request start or end',
  MOVE_TO_NEXT_REQUEST: 'move to next request start or end',
  GO_TO_LINE: 'gotoline'
};
function registerCommands({
  senseEditor,
  sendCurrentRequest,
  openDocumentation
}) {
  const throttledAutoIndent = (0, _lodash.throttle)(() => senseEditor.autoIndent(), 500, {
    leading: true,
    trailing: true
  });
  const coreEditor = senseEditor.getCoreEditor();
  coreEditor.registerKeyboardShortcut({
    keys: {
      win: 'Ctrl-Enter',
      mac: 'Command-Enter'
    },
    name: COMMANDS.SEND_TO_ELASTICSEARCH,
    fn: () => {
      sendCurrentRequest();
    }
  });
  coreEditor.registerKeyboardShortcut({
    name: COMMANDS.OPEN_DOCUMENTATION,
    keys: {
      win: 'Ctrl-/',
      mac: 'Command-/'
    },
    fn: () => {
      openDocumentation();
    }
  });
  coreEditor.registerKeyboardShortcut({
    name: COMMANDS.AUTO_INDENT_REQUEST,
    keys: {
      win: 'Ctrl-I',
      mac: 'Command-I'
    },
    fn: () => {
      throttledAutoIndent();
    }
  });
  coreEditor.registerKeyboardShortcut({
    name: COMMANDS.MOVE_TO_PREVIOUS_REQUEST,
    keys: {
      win: 'Ctrl-Up',
      mac: 'Command-Up'
    },
    fn: () => {
      senseEditor.moveToPreviousRequestEdge();
    }
  });
  coreEditor.registerKeyboardShortcut({
    name: COMMANDS.MOVE_TO_NEXT_REQUEST,
    keys: {
      win: 'Ctrl-Down',
      mac: 'Command-Down'
    },
    fn: () => {
      senseEditor.moveToNextRequestEdge(false);
    }
  });
  coreEditor.registerKeyboardShortcut({
    name: COMMANDS.GO_TO_LINE,
    keys: {
      win: 'Ctrl-L',
      mac: 'Command-L'
    },
    fn: editor => {
      var _prompt;
      const line = parseInt((_prompt = prompt('Enter line number')) !== null && _prompt !== void 0 ? _prompt : '', 10);
      if (!isNaN(line)) {
        editor.gotoLine(line);
      }
    }
  });
}
function unregisterCommands(senseEditor) {
  const coreEditor = senseEditor.getCoreEditor();
  Object.values(COMMANDS).forEach(command => {
    coreEditor.unregisterKeyboardShortcut(command);
  });
}