"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HistoryViewer = HistoryViewer;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _subscribe_console_resize_checker = require("../editor/legacy/subscribe_console_resize_checker");
var InputMode = _interopRequireWildcard(require("../../models/legacy_core_editor/mode/input"));
var editor = _interopRequireWildcard(require("../../models/legacy_core_editor"));
var _apply_editor_settings = require("../editor/legacy/console_editor/apply_editor_settings");
var _utils = require("../../../lib/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const inputMode = new InputMode.Mode();
function HistoryViewer({
  settings,
  req
}) {
  const divRef = (0, _react.useRef)(null);
  const viewerRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    const viewer = editor.createReadOnlyAceEditor(divRef.current);
    viewerRef.current = viewer;
    const unsubscribe = (0, _subscribe_console_resize_checker.subscribeResizeChecker)(divRef.current, viewer);
    return () => unsubscribe();
  }, []);
  (0, _react.useEffect)(() => {
    (0, _apply_editor_settings.applyCurrentSettings)(viewerRef.current, settings);
  }, [settings]);
  if (viewerRef.current) {
    const {
      current: viewer
    } = viewerRef;
    if (req) {
      const indent = true;
      const formattedData = req.data ? (0, _utils.formatRequestBodyDoc)([req.data], indent).data : '';
      const s = req.method + ' ' + req.endpoint + '\n' + formattedData;
      viewer.update(s, inputMode);
      viewer.clearSelection();
    } else {
      viewer.update(_i18n.i18n.translate('console.historyPage.noHistoryTextMessage', {
        defaultMessage: 'No history available'
      }), inputMode);
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "conHistory__viewer",
    ref: divRef
  });
}