"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DevToolsSettingsModal = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _keyboard_shortcuts = require("../containers/editor/legacy/console_editor/keyboard_shortcuts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const onceTimeInterval = () => _i18n.i18n.translate('console.settingsPage.refreshInterval.onceTimeInterval', {
  defaultMessage: 'Once, when console loads'
});
const everyNMinutesTimeInterval = value => _i18n.i18n.translate('console.settingsPage.refreshInterval.everyNMinutesTimeInterval', {
  defaultMessage: 'Every {value} {value, plural, one {minute} other {minutes}}',
  values: {
    value
  }
});
const everyHourTimeInterval = () => _i18n.i18n.translate('console.settingsPage.refreshInterval.everyHourTimeInterval', {
  defaultMessage: 'Every hour'
});
const PRESETS_IN_MINUTES = [0, 1, 10, 20, 60];
const intervalOptions = PRESETS_IN_MINUTES.map(value => ({
  value: (value * 60000).toString(),
  inputDisplay: value === 0 ? onceTimeInterval() : value === 60 ? everyHourTimeInterval() : everyNMinutesTimeInterval(value)
}));
const DevToolsSettingsModal = props => {
  const [fontSize, setFontSize] = (0, _react.useState)(props.settings.fontSize);
  const [wrapMode, setWrapMode] = (0, _react.useState)(props.settings.wrapMode);
  const [fields, setFields] = (0, _react.useState)(props.settings.autocomplete.fields);
  const [indices, setIndices] = (0, _react.useState)(props.settings.autocomplete.indices);
  const [templates, setTemplates] = (0, _react.useState)(props.settings.autocomplete.templates);
  const [dataStreams, setDataStreams] = (0, _react.useState)(props.settings.autocomplete.dataStreams);
  const [polling, setPolling] = (0, _react.useState)(props.settings.polling);
  const [pollInterval, setPollInterval] = (0, _react.useState)(props.settings.pollInterval);
  const [tripleQuotes, setTripleQuotes] = (0, _react.useState)(props.settings.tripleQuotes);
  const [isHistoryEnabled, setIsHistoryEnabled] = (0, _react.useState)(props.settings.isHistoryEnabled);
  const [isKeyboardShortcutsEnabled, setIsKeyboardShortcutsEnabled] = (0, _react.useState)(props.settings.isKeyboardShortcutsEnabled);
  const [isAccessibilityOverlayEnabled, setIsAccessibilityOverlayEnabled] = (0, _react.useState)(props.settings.isAccessibilityOverlayEnabled);
  const autoCompleteCheckboxes = [{
    id: 'fields',
    label: _i18n.i18n.translate('console.settingsPage.fieldsLabelText', {
      defaultMessage: 'Fields'
    }),
    stateSetter: setFields
  }, {
    id: 'indices',
    label: _i18n.i18n.translate('console.settingsPage.indicesAndAliasesLabelText', {
      defaultMessage: 'Indices and aliases'
    }),
    stateSetter: setIndices
  }, {
    id: 'templates',
    label: _i18n.i18n.translate('console.settingsPage.templatesLabelText', {
      defaultMessage: 'Templates'
    }),
    stateSetter: setTemplates
  }, {
    id: 'dataStreams',
    label: _i18n.i18n.translate('console.settingsPage.dataStreamsLabelText', {
      defaultMessage: 'Data streams'
    }),
    stateSetter: setDataStreams
  }];
  const checkboxIdToSelectedMap = {
    fields,
    indices,
    templates,
    dataStreams
  };
  const onAutocompleteChange = optionId => {
    const option = _lodash.default.find(autoCompleteCheckboxes, item => item.id === optionId);
    if (option) {
      option.stateSetter(!checkboxIdToSelectedMap[optionId]);
    }
  };
  function saveSettings() {
    props.onSaveSettings({
      fontSize,
      wrapMode,
      autocomplete: {
        fields,
        indices,
        templates,
        dataStreams
      },
      polling,
      pollInterval,
      tripleQuotes,
      isHistoryEnabled,
      isKeyboardShortcutsEnabled,
      isAccessibilityOverlayEnabled
    });
  }
  const onPollingIntervalChange = (0, _react.useCallback)(value => {
    const sanitizedValue = parseInt(value, 10);
    setPolling(!!sanitizedValue);
    setPollInterval(sanitizedValue);
  }, []);
  const toggleKeyboardShortcuts = (0, _react.useCallback)(isEnabled => {
    if (props.editorInstance) {
      (0, _keyboard_shortcuts.unregisterCommands)(props.editorInstance);
      setIsKeyboardShortcutsEnabled(isEnabled);
    }
  }, [props.editorInstance]);
  const toggleAccessibilityOverlay = (0, _react.useCallback)(isEnabled => setIsAccessibilityOverlayEnabled(isEnabled), []);
  const toggleSavingToHistory = (0, _react.useCallback)(isEnabled => setIsHistoryEnabled(isEnabled), []);

  // It only makes sense to show polling options if the user needs to fetch any data.
  const pollingFields = fields || indices || templates || dataStreams ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.refreshingDataLabel",
      defaultMessage: "Refresh frequency"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.refreshingDataDescription",
      defaultMessage: "Console refreshes autocomplete suggestions by querying Elasticsearch. Use less frequent refreshes to reduce bandwidth costs."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: intervalOptions,
    valueOfSelected: pollInterval.toString(),
    onChange: onPollingIntervalChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "autocompletePolling",
    id: "autocompletePolling",
    onClick: () => {
      // Only refresh the currently selected settings.
      props.refreshAutocompleteSettings({
        fields,
        indices,
        templates,
        dataStreams
      });
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Refresh autocomplete suggestions",
    id: "console.settingsPage.refreshButtonLabel"
  }))) : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "devToolsSettingsModal",
    className: "conApp__settingsModal",
    onClose: props.onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.settingsPage.pageTitle",
    defaultMessage: "Console settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.fontSizeLabel",
      defaultMessage: "Font size"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    autoFocus: true,
    "data-test-subj": "setting-font-size-input",
    value: fontSize,
    min: 6,
    max: 50,
    onChange: e => {
      const val = parseInt(e.target.value, 10);
      if (!val) return;
      setFontSize(val);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: wrapMode,
    "data-test-subj": "settingsWrapLines",
    id: "wrapLines",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Wrap long lines",
      id: "console.settingsPage.wrapLongLinesLabelText"
    }),
    onChange: e => setWrapMode(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.jsonSyntaxLabel",
      defaultMessage: "JSON syntax"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: tripleQuotes,
    "data-test-subj": "tripleQuotes",
    id: "tripleQuotes",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Use triple quotes in output",
      id: "console.settingsPage.tripleQuotesMessage"
    }),
    onChange: e => setTripleQuotes(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.historyLabel",
      defaultMessage: "History"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: isHistoryEnabled,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Save requests to history",
      id: "console.settingsPage.saveRequestsToHistoryLabel"
    }),
    onChange: e => toggleSavingToHistory(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.keyboardShortcutsLabel",
      defaultMessage: "Keyboard shortcuts"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: isKeyboardShortcutsEnabled,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Enable keyboard shortcuts",
      id: "console.settingsPage.enableKeyboardShortcutsLabel"
    }),
    onChange: e => toggleKeyboardShortcuts(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.accessibilityOverlayLabel",
      defaultMessage: "Accessibility overlay"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "enableA11yOverlay",
    checked: isAccessibilityOverlayEnabled,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Enable accessibility overlay",
      id: "console.settingsPage.enableAccessibilityOverlayLabel"
    }),
    onChange: e => toggleAccessibilityOverlay(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    labelType: "legend",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.settingsPage.autocompleteLabel",
      defaultMessage: "Autocomplete"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
    options: autoCompleteCheckboxes.map(opts => {
      const {
        stateSetter,
        ...rest
      } = opts;
      return rest;
    }),
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: e => {
      onAutocompleteChange(e);
    }
  })), pollingFields), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "settingsCancelButton",
    onClick: props.onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.settingsPage.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "settings-save-button",
    onClick: saveSettings
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.settingsPage.saveButtonLabel",
    defaultMessage: "Save"
  }))));
};
exports.DevToolsSettingsModal = DevToolsSettingsModal;