"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ConsoleMenu", {
  enumerable: true,
  get: function () {
    return _console_menu.ConsoleMenu;
  }
});
exports.DevToolsVariablesFlyoutLazy = exports.DevToolsVariablesFlyout = exports.DevToolsSettingsModalLazy = exports.DevToolsSettingsModal = void 0;
Object.defineProperty(exports, "EditorContentSpinner", {
  enumerable: true,
  get: function () {
    return _editor_content_spinner.EditorContentSpinner;
  }
});
Object.defineProperty(exports, "HelpPanel", {
  enumerable: true,
  get: function () {
    return _help_panel.HelpPanel;
  }
});
Object.defineProperty(exports, "NetworkRequestStatusBar", {
  enumerable: true,
  get: function () {
    return _network_request_status_bar.NetworkRequestStatusBar;
  }
});
Object.defineProperty(exports, "SomethingWentWrongCallout", {
  enumerable: true,
  get: function () {
    return _something_went_wrong_callout.SomethingWentWrongCallout;
  }
});
Object.defineProperty(exports, "TopNavMenu", {
  enumerable: true,
  get: function () {
    return _top_nav_menu.TopNavMenu;
  }
});
Object.defineProperty(exports, "WelcomePanel", {
  enumerable: true,
  get: function () {
    return _welcome_panel.WelcomePanel;
  }
});
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _network_request_status_bar = require("./network_request_status_bar");
var _something_went_wrong_callout = require("./something_went_wrong_callout");
var _top_nav_menu = require("./top_nav_menu");
var _console_menu = require("./console_menu");
var _welcome_panel = require("./welcome_panel");
var _help_panel = require("./help_panel");
var _editor_content_spinner = require("./editor_content_spinner");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * The Lazily-loaded `DevToolsSettingsModal` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const DevToolsSettingsModalLazy = exports.DevToolsSettingsModalLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./settings_modal'))).then(({
  DevToolsSettingsModal
}) => ({
  default: DevToolsSettingsModal
})));

/**
 * A `DevToolsSettingsModal` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DevToolsSettingsModalLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const DevToolsSettingsModal = exports.DevToolsSettingsModal = (0, _sharedUxUtility.withSuspense)(DevToolsSettingsModalLazy);

/**
 * The Lazily-loaded `DevToolsVariablesFlyout` component.  Consumers should use `React.Suspense` or
 * the withSuspense` HOC to load this component.
 */
const DevToolsVariablesFlyoutLazy = exports.DevToolsVariablesFlyoutLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./variables'))).then(({
  DevToolsVariablesFlyout
}) => ({
  default: DevToolsVariablesFlyout
})));

/**
 * A `DevToolsVariablesFlyout` component that is wrapped by the `withSuspense` HOC. This component can
 * be used directly by consumers and will load the `DevToolsVariablesFlyoutLazy` component lazily with
 * a predefined fallback and error boundary.
 */
const DevToolsVariablesFlyout = exports.DevToolsVariablesFlyout = (0, _sharedUxUtility.withSuspense)(DevToolsVariablesFlyoutLazy);