"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ByteSizeValue", {
  enumerable: true,
  get: function () {
    return _byte_size_value.ByteSizeValue;
  }
});
Object.defineProperty(exports, "ObjectType", {
  enumerable: true,
  get: function () {
    return _types.ObjectType;
  }
});
Object.defineProperty(exports, "SchemaTypeError", {
  enumerable: true,
  get: function () {
    return _errors.SchemaTypeError;
  }
});
Object.defineProperty(exports, "Type", {
  enumerable: true,
  get: function () {
    return _types.Type;
  }
});
Object.defineProperty(exports, "ValidationError", {
  enumerable: true,
  get: function () {
    return _errors.ValidationError;
  }
});
Object.defineProperty(exports, "isConfigSchema", {
  enumerable: true,
  get: function () {
    return _typeguards.isConfigSchema;
  }
});
exports.metaFields = void 0;
Object.defineProperty(exports, "offeringBasedSchema", {
  enumerable: true,
  get: function () {
    return _helpers.offeringBasedSchema;
  }
});
exports.schema = void 0;
var _references = require("./src/references");
var _types = require("./src/types");
var _byte_size_value = require("./src/byte_size_value");
var _errors = require("./src/errors");
var _typeguards = require("./src/typeguards");
var _helpers = require("./src/helpers");
var _oas_meta_fields = require("./src/oas_meta_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function any(options) {
  return new _types.AnyType(options);
}
function boolean(options) {
  return new _types.BooleanType(options);
}
function buffer(options) {
  return new _types.BufferType(options);
}
function stream(options) {
  return new _types.StreamType(options);
}
function string(options) {
  return new _types.StringType(options);
}
function uri(options) {
  return new _types.URIType(options);
}
function literal(value) {
  return new _types.LiteralType(value);
}
function number(options) {
  return new _types.NumberType(options);
}
function byteSize(options) {
  return new _types.ByteSizeType(options);
}
function duration(options) {
  return new _types.DurationType(options);
}
function never() {
  return new _types.NeverType();
}
function ip(options) {
  return new _types.IpType(options);
}

/**
 * Create an optional type
 */
function maybe(type) {
  return new _types.MaybeType(type);
}
function nullable(type) {
  return schema.oneOf([type, schema.literal(null)], {
    defaultValue: null
  });
}
function object(props, options) {
  return new _types.ObjectType(props, options);
}
function arrayOf(itemType, options) {
  return new _types.ArrayType(itemType, options);
}
function mapOf(keyType, valueType, options) {
  return new _types.MapOfType(keyType, valueType, options);
}
function recordOf(keyType, valueType, options) {
  return new _types.RecordOfType(keyType, valueType, options);
}
function oneOf(types, options) {
  return new _types.UnionType(types, options);
}
function allOf(types, options) {
  return new _types.IntersectionType(types, options);
}
function contextRef(key) {
  return new _references.ContextReference(key);
}
function siblingRef(key) {
  return new _references.SiblingReference(key);
}
function conditional(leftOperand, rightOperand, equalType, notEqualType, options) {
  return new _types.ConditionalType(leftOperand, rightOperand, equalType, notEqualType, options);
}

/**
 * Useful for creating recursive schemas.
 */
function lazy(id) {
  return new _types.Lazy(id);
}
const schema = exports.schema = {
  allOf,
  any,
  arrayOf,
  boolean,
  buffer,
  byteSize,
  conditional,
  contextRef,
  duration,
  intersection: allOf,
  ip,
  lazy,
  literal,
  mapOf,
  maybe,
  nullable,
  never,
  number,
  object,
  oneOf,
  recordOf,
  stream,
  siblingRef,
  string,
  uri
};
const metaFields = exports.metaFields = Object.freeze({
  META_FIELD_X_OAS_ANY: _oas_meta_fields.META_FIELD_X_OAS_ANY,
  META_FIELD_X_OAS_OPTIONAL: _oas_meta_fields.META_FIELD_X_OAS_OPTIONAL,
  META_FIELD_X_OAS_DEPRECATED: _oas_meta_fields.META_FIELD_X_OAS_DEPRECATED,
  META_FIELD_X_OAS_MAX_LENGTH: _oas_meta_fields.META_FIELD_X_OAS_MAX_LENGTH,
  META_FIELD_X_OAS_MIN_LENGTH: _oas_meta_fields.META_FIELD_X_OAS_MIN_LENGTH,
  META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES: _oas_meta_fields.META_FIELD_X_OAS_GET_ADDITIONAL_PROPERTIES
});