"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiSlice = exports.uiReducer = exports.switchColorPickerVisibility = exports.showColorPickerVisibility = exports.hideColorPickerVisibility = exports.colorPickerVisibility = void 0;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialState = {
  colorPicker: {
    index: 0,
    visibile: false,
    type: 'assignment'
  }
};
const uiSlice = exports.uiSlice = (0, _toolkit.createSlice)({
  name: 'colorMapping',
  initialState,
  reducers: {
    colorPickerVisibility: (state, action) => {
      state.colorPicker.visibile = action.payload.visible;
      state.colorPicker.index = action.payload.index;
      state.colorPicker.type = action.payload.type;
    },
    switchColorPickerVisibility: state => {
      state.colorPicker.visibile = !state.colorPicker.visibile;
    },
    showColorPickerVisibility: state => {
      state.colorPicker.visibile = true;
    },
    hideColorPickerVisibility: state => {
      state.colorPicker.visibile = false;
    }
  }
});
const {
  colorPickerVisibility,
  switchColorPickerVisibility,
  showColorPickerVisibility,
  hideColorPickerVisibility
} = uiSlice.actions;
exports.hideColorPickerVisibility = hideColorPickerVisibility;
exports.showColorPickerVisibility = showColorPickerVisibility;
exports.switchColorPickerVisibility = switchColorPickerVisibility;
exports.colorPickerVisibility = colorPickerVisibility;
const uiReducer = exports.uiReducer = uiSlice.reducer;