"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  AVAILABLE_PALETTES: true,
  getPalette: true
};
exports.AVAILABLE_PALETTES = void 0;
exports.getPalette = getPalette;
var _elastic_brand = require("./elastic_brand");
Object.keys(_elastic_brand).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _elastic_brand[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _elastic_brand[key];
    }
  });
});
var _eui_amsterdam = require("./eui_amsterdam");
Object.keys(_eui_amsterdam).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _eui_amsterdam[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _eui_amsterdam[key];
    }
  });
});
var _kibana_legacy = require("./kibana_legacy");
Object.keys(_kibana_legacy).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _kibana_legacy[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _kibana_legacy[key];
    }
  });
});
var _neutral = require("./neutral");
Object.keys(_neutral).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _neutral[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _neutral[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AVAILABLE_PALETTES = exports.AVAILABLE_PALETTES = new Map([[_eui_amsterdam.EUIAmsterdamColorBlindPalette.id, _eui_amsterdam.EUIAmsterdamColorBlindPalette], [_elastic_brand.ElasticBrandPalette.id, _elastic_brand.ElasticBrandPalette], [_kibana_legacy.KibanaV7LegacyPalette.id, _kibana_legacy.KibanaV7LegacyPalette], [_neutral.NeutralPalette.id, _neutral.NeutralPalette]]);

/**
 * This function should be instanciated once at the root of the component with the available palettes and
 * a choosed default one and shared across components to keep a single point of truth of the available palettes and the default
 * one.
 */
function getPalette(palettes, defaultPalette) {
  return paletteId => {
    var _palettes$get;
    return (_palettes$get = palettes.get(paletteId)) !== null && _palettes$get !== void 0 ? _palettes$get : defaultPalette;
  };
}