"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Container = Container;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _palette_selector = require("../palette_selector/palette_selector");
var _color_mapping = require("../../state/color_mapping");
var _palettes = require("../../palettes");
var _selectors = require("../../state/selectors");
var _gradient = require("../palette_selector/gradient");
var _neutral = require("../../palettes/neutral");
var _scale = require("../palette_selector/scale");
var _unassigned_terms_config = require("./unassigned_terms_config");
var _assigments = require("./assigments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Container({
  data,
  palettes,
  isDarkMode,
  specialTokens
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getPaletteFn = (0, _palettes.getPalette)(palettes, _neutral.NeutralPalette);
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(getPaletteFn));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const assignments = (0, _reactRedux.useSelector)(_selectors.selectComputedAssignments);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_palette_selector.PaletteSelector, {
    palettes: palettes,
    getPaletteFn: getPaletteFn,
    isDarkMode: isDarkMode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_scale.ScaleMode, {
    getPaletteFn: getPaletteFn
  })))), colorMode.type === 'gradient' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              position: absolute;
              right: 0;
            }`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('coloring.colorMapping.container.invertGradientButtonLabel', {
      defaultMessage: 'Invert gradient'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "lns-colorMapping-invertGradient",
    iconType: "merge",
    size: "xs",
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.container.invertGradientButtonLabel', {
      defaultMessage: 'Invert gradient'
    }),
    onClick: () => {
      dispatch((0, _color_mapping.changeGradientSortOrder)(colorMode.sort === 'asc' ? 'desc' : 'asc'));
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.container.gradientHeader', {
      defaultMessage: 'Gradient'
    })
  }, /*#__PURE__*/_react.default.createElement(_gradient.Gradient, {
    colorMode: colorMode,
    getPaletteFn: getPaletteFn,
    isDarkMode: isDarkMode,
    paletteId: palette.id
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.container.mappingAssignmentHeader', {
      defaultMessage: 'Color assignments'
    })
  }, /*#__PURE__*/_react.default.createElement(_assigments.AssignmentsConfig, {
    isDarkMode: isDarkMode,
    data: data,
    palettes: palettes,
    specialTokens: specialTokens
  }))), assignments.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_unassigned_terms_config.UnassignedTermsConfig, {
    data: data,
    isDarkMode: isDarkMode,
    palettes: palettes
  })));
}