"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteColors = PaletteColors;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _color_math = require("../../color/color_math");
var _neutral = require("../../palettes/neutral");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function PaletteColors({
  palette,
  isDarkMode,
  color,
  getPaletteFn,
  selectColor
}) {
  const colors = Array.from({
    length: palette.colorCount
  }, (d, i) => {
    return palette.getColor(i, isDarkMode, false);
  });
  const neutralColors = Array.from({
    length: _neutral.NeutralPalette.colorCount
  }, (d, i) => {
    return _neutral.NeutralPalette.getColor(i, isDarkMode, false);
  });
  const originalColor = color.type === 'categorical' ? color.paletteId === _neutral.NeutralPalette.id ? _neutral.NeutralPalette.getColor(color.colorIndex, isDarkMode, false) : getPaletteFn(color.paletteId).getColor(color.colorIndex, isDarkMode, false) : color.colorCode;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      padding: 8
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('coloring.colorMapping.colorPicker.paletteColorsLabel', {
    defaultMessage: 'Palette colors'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    wrap: true,
    alignItems: "center",
    justifyContent: "flexStart"
  }, colors.map((c, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: c,
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
    "data-test-subj": `lns-colorMapping-colorPicker-staticColor-${index}`,
    style: {
      border: (0, _color_math.isSameColor)(c, originalColor) ? '2px solid black' : 'transparent'
    },
    color: c,
    onClick: () => selectColor({
      type: 'categorical',
      paletteId: palette.id,
      colorIndex: index
    })
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      padding: 8,
      paddingTop: 0
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('coloring.colorMapping.colorPicker.themeAwareColorsLabel', {
    defaultMessage: 'Neutral colors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: _i18n.i18n.translate('coloring.colorMapping.colorPicker.themeAwareColorsTooltip', {
      defaultMessage: 'The provided neutral colors are theme-aware and will change appropriately when switching between light and dark themes.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    tabIndex: 0,
    type: "questionInCircle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    wrap: true,
    alignItems: "center",
    justifyContent: "flexStart"
  }, neutralColors.map((c, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: c,
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPickerSwatch, {
    style: {
      border: (0, _color_math.isSameColor)(c, originalColor) ? '2px solid black' : 'transparent'
    },
    "data-test-subj": `lns-colorMapping-colorPicker-neutralColor-${index}`,
    color: c,
    onClick: () => selectColor({
      type: 'categorical',
      paletteId: _neutral.NeutralPalette.id,
      colorIndex: index
    })
  })))))));
}