"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpecialAssignment = SpecialAssignment;
var _reactRedux = require("react-redux");
var _react = _interopRequireDefault(require("react"));
var _color_swatch = require("../color_picker/color_swatch");
var _color_mapping = require("../../state/color_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SpecialAssignment({
  assignmentColor,
  index,
  palette,
  getPaletteFn,
  isDarkMode,
  total
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  return /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "specialAssignment",
    colorMode: {
      type: 'categorical'
    },
    assignmentColor: assignmentColor,
    getPaletteFn: getPaletteFn,
    index: index,
    palette: palette,
    total: total,
    swatchShape: "square",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateSpecialAssignmentColor)({
        assignmentIndex: index,
        color
      }));
    }
  });
}