"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cspBenchmarkRule = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _types = require("../../common/types");
var _constants = require("../../common/constants");
var _migrations = require("./migrations");
var _mappings = require("./mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cspBenchmarkRule = exports.cspBenchmarkRule = {
  name: _constants.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'agnostic',
  management: {
    importableAndExportable: true,
    visibleInManagement: true
  },
  schemas: {
    '8.3.0': _types.rulesV1.cspBenchmarkRuleSchema,
    '8.4.0': _types.rulesV2.cspBenchmarkRuleSchema,
    '8.7.0': _types.rulesV3.cspBenchmarkRuleSchema
  },
  migrations: _migrations.cspBenchmarkRuleMigrations,
  mappings: _mappings.cspBenchmarkRuleSavedObjectMapping
};