"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopPatchableVulnerabilities = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPatchableVulnerabilitiesQuery = () => ({
  size: 0,
  query: {
    bool: {
      filter: [{
        exists: {
          field: 'package.fixed_version'
        }
      }]
    }
  },
  index: _constants.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS,
  aggs: {
    patchable_vulnerabilities: {
      terms: {
        field: 'vulnerability.id',
        order: {
          _count: 'desc'
        },
        size: 10
      },
      aggs: {
        score: {
          max: {
            field: 'vulnerability.score.base'
          }
        },
        version: {
          terms: {
            field: 'vulnerability.score.version',
            size: 1
          }
        },
        packageFixVersion: {
          terms: {
            field: 'package.fixed_version',
            size: 1
          }
        }
      }
    }
  }
});
const getTopPatchableVulnerabilities = async esClient => {
  var _queryResult$aggregat;
  const queryResult = await esClient.search(getPatchableVulnerabilitiesQuery());
  if (!(queryResult !== null && queryResult !== void 0 && (_queryResult$aggregat = queryResult.aggregations) !== null && _queryResult$aggregat !== void 0 && _queryResult$aggregat.patchable_vulnerabilities)) return [];
  return queryResult.aggregations.patchable_vulnerabilities.buckets.map(vulnerability => {
    var _vulnerability$score, _vulnerability$versio, _vulnerability$versio2, _vulnerability$versio3, _vulnerability$versio4, _vulnerability$packag, _vulnerability$packag2, _vulnerability$packag3, _vulnerability$packag4;
    return {
      cve: vulnerability.key,
      cvss: {
        score: (_vulnerability$score = vulnerability.score) === null || _vulnerability$score === void 0 ? void 0 : _vulnerability$score.value,
        version: (_vulnerability$versio = (_vulnerability$versio2 = vulnerability.version) === null || _vulnerability$versio2 === void 0 ? void 0 : (_vulnerability$versio3 = _vulnerability$versio2.buckets) === null || _vulnerability$versio3 === void 0 ? void 0 : (_vulnerability$versio4 = _vulnerability$versio3[0]) === null || _vulnerability$versio4 === void 0 ? void 0 : _vulnerability$versio4.key) !== null && _vulnerability$versio !== void 0 ? _vulnerability$versio : ''
      },
      packageFixVersion: (_vulnerability$packag = (_vulnerability$packag2 = vulnerability.packageFixVersion) === null || _vulnerability$packag2 === void 0 ? void 0 : (_vulnerability$packag3 = _vulnerability$packag2.buckets) === null || _vulnerability$packag3 === void 0 ? void 0 : (_vulnerability$packag4 = _vulnerability$packag3[0]) === null || _vulnerability$packag4 === void 0 ? void 0 : _vulnerability$packag4.key) !== null && _vulnerability$packag !== void 0 ? _vulnerability$packag : '',
      vulnerabilityCount: vulnerability.doc_count
    };
  });
};
exports.getTopPatchableVulnerabilities = getTopPatchableVulnerabilities;