"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGetCspBenchmarkRulesStatesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../common/constants");
var _v = require("./v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defineGetCspBenchmarkRulesStatesRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH
}).addVersion({
  version: '1',
  validate: {}
}, async (context, request, response) => {
  if (!(await context.fleet).authz.fleet.all) {
    return response.forbidden();
  }
  const cspContext = await context.csp;
  try {
    const encryptedSoClient = cspContext.encryptedSavedObjects;
    const rulesStates = await (0, _v.getCspBenchmarkRulesStatesHandler)(encryptedSoClient);
    return response.ok({
      body: rulesStates
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch CSP benchmark rules state: ${error.message}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode || 500 // Default to 500 if no specific status code is provided
    });
  }
});
exports.defineGetCspBenchmarkRulesStatesRoute = defineGetCspBenchmarkRulesStatesRoute;