"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortedCspBenchmarkRulesTemplates = exports.getBenchmarkIdFromPackagePolicyId = void 0;
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _benchmarks = require("../../benchmarks/benchmarks");
var _helpers = require("../../../../common/utils/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSortedCspBenchmarkRulesTemplates = (cspBenchmarkRules, sortDirection) => {
  return cspBenchmarkRules.slice().sort((a, b) => {
    var _a$metadata, _a$metadata$benchmark, _b$metadata, _b$metadata$benchmark;
    const ruleNumberA = a === null || a === void 0 ? void 0 : (_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : (_a$metadata$benchmark = _a$metadata.benchmark) === null || _a$metadata$benchmark === void 0 ? void 0 : _a$metadata$benchmark.rule_number;
    const ruleNumberB = b === null || b === void 0 ? void 0 : (_b$metadata = b.metadata) === null || _b$metadata === void 0 ? void 0 : (_b$metadata$benchmark = _b$metadata.benchmark) === null || _b$metadata$benchmark === void 0 ? void 0 : _b$metadata$benchmark.rule_number;
    const versionA = (0, _valid.default)(ruleNumberA);
    const versionB = (0, _valid.default)(ruleNumberB);
    if (versionA !== null && versionB !== null) {
      return sortDirection === 'asc' ? (0, _compare.default)(versionA, versionB) : (0, _compare.default)(versionB, versionA);
    } else {
      return sortDirection === 'asc' ? String(ruleNumberA).localeCompare(String(ruleNumberB), undefined, {
        numeric: true,
        sensitivity: 'base'
      }) : String(ruleNumberB).localeCompare(String(ruleNumberA), undefined, {
        numeric: true,
        sensitivity: 'base'
      });
    }
  });
};
exports.getSortedCspBenchmarkRulesTemplates = getSortedCspBenchmarkRulesTemplates;
const getBenchmarkIdFromPackagePolicyId = async (soClient, packagePolicyId) => {
  const res = await soClient.get(_benchmarks.PACKAGE_POLICY_SAVED_OBJECT_TYPE, packagePolicyId);
  return (0, _helpers.getBenchmarkFromPackagePolicy)(res.attributes.inputs);
};
exports.getBenchmarkIdFromPackagePolicyId = getBenchmarkIdFromPackagePolicyId;