"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityTablePanelSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _vulnerability_table_panel = require("./vulnerability_table_panel.config");
var _vulnerability_table_panel2 = require("./vulnerability_table_panel");
var _use_navigate_findings = require("../../common/hooks/use_navigate_findings");
var _vulnerability_badges = require("../../components/vulnerability_badges");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityTablePanelSection = () => {
  var _getVulnerabilityDash, _getVulnerabilityDash2, _getVulnerabilityDash3, _getVulnerabilityDash4, _getVulnerabilityDash5, _getVulnerabilityDash6, _getVulnerabilityDash7, _getVulnerabilityDash8, _getVulnerabilityDash9;
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navToVulnerabilities = (0, _use_navigate_findings.useNavigateVulnerabilities)();
  const onCellClick = (0, _react.useCallback)(filters => {
    navToVulnerabilities(filters, [_constants.VULNERABILITY_GROUPING_OPTIONS.NONE]);
  }, [navToVulnerabilities]);
  const onViewVulnerabilitiesByResourceClick = (0, _react.useCallback)(() => {
    navToVulnerabilities({}, [_constants.VULNERABILITY_GROUPING_OPTIONS.RESOURCE_ID]);
  }, [navToVulnerabilities]);
  const onViewPatchableVulnerabilitiesClick = (0, _react.useCallback)(() => {
    navToVulnerabilities({
      [_constants.VULNERABILITY_FIELDS.PACKAGE_FIXED_VERSION]: '*'
    }, [_constants.VULNERABILITY_GROUPING_OPTIONS.NONE]);
  }, [navToVulnerabilities]);
  const onViewVulnerabilitiesClick = (0, _react.useCallback)(() => {
    navToVulnerabilities({}, [_constants.VULNERABILITY_GROUPING_OPTIONS.NONE]);
  }, [navToVulnerabilities]);
  const topVulnerableResourceColumns = (0, _react.useMemo)(() => [{
    field: 'resource.id',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.resourceId', {
      defaultMessage: 'Resource ID'
    }),
    render: resourceId => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'resource.id': resourceId
      }),
      className: "eui-textTruncate"
    }, resourceId)
  }, {
    field: 'resource.name',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.resourceName', {
      defaultMessage: 'Resource Name'
    }),
    render: resourceName => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'resource.name': resourceName
      }),
      className: "eui-textTruncate",
      color: "text"
    }, resourceName)
  }, {
    field: 'cloudRegion',
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.region', {
      defaultMessage: 'Region'
    }),
    render: region => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'cloud.region': region
      }),
      className: "eui-textTruncate",
      color: "text"
    }, region),
    width: '140'
  }, {
    field: 'vulnerabilityCount',
    name: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortDown',
      style: {
        marginRight: euiTheme.size.xs
      }
    }), _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.vulnerabilities', {
      defaultMessage: 'Vulnerabilities'
    })),
    width: '120',
    align: 'right'
  }], [onCellClick, euiTheme.size.xs]);
  const topPatchableVulnerabilitiesColumns = (0, _react.useMemo)(() => [{
    field: 'cve',
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.cve', {
      defaultMessage: 'CVE'
    }),
    render: cve => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'vulnerability.id': cve,
        'package.fixed_version': '*'
      }),
      className: "eui-textTruncate"
    }, cve)
  }, {
    field: 'cvss',
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.version', {
      defaultMessage: 'CVSS'
    }),
    render: cvss => {
      if (!cvss.score || !cvss.version) {
        return null;
      }
      const esQuery = {
        'vulnerability.score.base': cvss.score
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => onCellClick(esQuery)
      }, /*#__PURE__*/_react.default.createElement(_vulnerability_badges.CVSScoreBadge, {
        version: cvss.version,
        score: cvss.score
      }));
    }
  }, {
    field: 'packageFixVersion',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topPatchableVulnerabilities.column.fixedVersion', {
      defaultMessage: 'Fix Version'
    }),
    render: packageFixVersion => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'package.fixed_version': packageFixVersion
      }),
      className: "eui-textTruncate",
      color: "text"
    }, packageFixVersion)
  }, {
    field: 'vulnerabilityCount',
    name: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortDown',
      style: {
        marginRight: euiTheme.size.xs
      }
    }), _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerableResources.column.vulnerabilityCount', {
      defaultMessage: 'Vulnerabilities'
    })),
    align: 'right'
  }], [onCellClick, euiTheme.size.xs]);
  const topVulnerabilitiesColumns = (0, _react.useMemo)(() => [{
    field: 'cve',
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.cve', {
      defaultMessage: 'CVE'
    }),
    render: cve => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'vulnerability.id': cve
      }),
      className: "eui-textTruncate"
    }, cve)
  }, {
    field: 'cvss',
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.version', {
      defaultMessage: 'CVSS'
    }),
    render: cvss => {
      if (!cvss.score || !cvss.version) {
        return null;
      }
      const esQuery = {
        'vulnerability.score.base': cvss.score
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => onCellClick(esQuery)
      }, /*#__PURE__*/_react.default.createElement(_vulnerability_badges.CVSScoreBadge, {
        version: cvss.version,
        score: cvss.score
      }));
    }
  }, {
    field: 'severity',
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.severity', {
      defaultMessage: 'Severity'
    }),
    render: severity => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'vulnerability.severity': severity
      }),
      color: "text"
    }, /*#__PURE__*/_react.default.createElement(_vulnerability_badges.SeverityStatusBadge, {
      severity: severity
    }))
  }, {
    field: 'packageName',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.packageName', {
      defaultMessage: 'Package Name'
    }),
    render: packageName => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'package.name': packageName
      }),
      className: "eui-textTruncate",
      color: "text"
    }, packageName)
  }, {
    field: 'packageVersion',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.packageVersion', {
      defaultMessage: 'Package Version'
    }),
    render: packageVersion => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'package.version': packageVersion
      }),
      className: "eui-textTruncate",
      color: "text"
    }, packageVersion)
  }, {
    field: 'packageFixVersion',
    truncateText: true,
    name: _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.fixedVersion', {
      defaultMessage: 'Fix Version'
    }),
    render: packageFixVersion => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => onCellClick({
        'package.fixed_version': packageFixVersion
      }),
      className: "eui-textTruncate",
      color: "text"
    }, packageFixVersion)
  }, {
    field: 'vulnerabilityCount',
    name: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortDown',
      style: {
        marginRight: euiTheme.size.xs
      }
    }), _i18n.i18n.translate('xpack.csp.cnvmDashboardTable.section.topVulnerability.column.vulnerabilities', {
      defaultMessage: 'Vulnerabilities'
    })),
    align: 'right'
  }], [onCellClick, euiTheme.size.xs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, !!((_getVulnerabilityDash = getVulnerabilityDashboard.data) !== null && _getVulnerabilityDash !== void 0 && (_getVulnerabilityDash2 = _getVulnerabilityDash.topVulnerableResources) !== null && _getVulnerabilityDash2 !== void 0 && _getVulnerabilityDash2.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_vulnerability_table_panel2.VulnerabilityTablePanel, {
    items: (_getVulnerabilityDash3 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash3 === void 0 ? void 0 : _getVulnerabilityDash3.topVulnerableResources,
    columns: topVulnerableResourceColumns,
    tableType: _vulnerability_table_panel.DASHBOARD_TABLE_TYPES.TOP_VULNERABLE_RESOURCES,
    onViewVulnerabilitiesClick: onViewVulnerabilitiesByResourceClick
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !!((_getVulnerabilityDash4 = getVulnerabilityDashboard.data) !== null && _getVulnerabilityDash4 !== void 0 && (_getVulnerabilityDash5 = _getVulnerabilityDash4.topPatchableVulnerabilities) !== null && _getVulnerabilityDash5 !== void 0 && _getVulnerabilityDash5.length) && /*#__PURE__*/_react.default.createElement(_vulnerability_table_panel2.VulnerabilityTablePanel, {
    items: (_getVulnerabilityDash6 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash6 === void 0 ? void 0 : _getVulnerabilityDash6.topPatchableVulnerabilities,
    columns: topPatchableVulnerabilitiesColumns,
    tableType: _vulnerability_table_panel.DASHBOARD_TABLE_TYPES.TOP_PATCH_VULNERABILITIES,
    onViewVulnerabilitiesClick: onViewPatchableVulnerabilitiesClick
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !!((_getVulnerabilityDash7 = getVulnerabilityDashboard.data) !== null && _getVulnerabilityDash7 !== void 0 && (_getVulnerabilityDash8 = _getVulnerabilityDash7.topVulnerabilities) !== null && _getVulnerabilityDash8 !== void 0 && _getVulnerabilityDash8.length) && /*#__PURE__*/_react.default.createElement(_vulnerability_table_panel2.VulnerabilityTablePanel, {
    items: (_getVulnerabilityDash9 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash9 === void 0 ? void 0 : _getVulnerabilityDash9.topVulnerabilities,
    columns: topVulnerabilitiesColumns,
    tableType: _vulnerability_table_panel.DASHBOARD_TABLE_TYPES.TOP_VULNERABILITIES,
    onViewVulnerabilitiesClick: onViewVulnerabilitiesClick
  }));
};
exports.VulnerabilityTablePanelSection = VulnerabilityTablePanelSection;