"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Vulnerabilities = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../../common/constants");
var _no_vulnerabilities_states = require("../../components/no_vulnerabilities_states");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _constants2 = require("../../common/navigation/constants");
var _use_data_view = require("../../common/api/use_data_view");
var _latest_vulnerabilities_container = require("./latest_vulnerabilities_container");
var _data_view_context = require("../../common/contexts/data_view_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Vulnerabilities = () => {
  var _getSetupStatus$data, _getSetupStatus$data$;
  const dataViewQuery = (0, _use_data_view.useDataView)(_constants.LATEST_VULNERABILITIES_INDEX_PATTERN);
  const getSetupStatus = (0, _use_setup_status_api.useCspSetupStatusApi)();
  if ((getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$data = getSetupStatus.data) === null || _getSetupStatus$data === void 0 ? void 0 : (_getSetupStatus$data$ = _getSetupStatus$data.vuln_mgmt) === null || _getSetupStatus$data$ === void 0 ? void 0 : _getSetupStatus$data$.status) !== 'indexed') return /*#__PURE__*/_react.default.createElement(_no_vulnerabilities_states.NoVulnerabilitiesStates, null);
  const dataViewContextValue = {
    dataView: dataViewQuery.data,
    dataViewRefetch: dataViewQuery.refetch,
    dataViewIsRefetching: dataViewQuery.isRefetching
  };
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: dataViewQuery
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.findingsNavigation.vulnerabilities.path,
    render: () => /*#__PURE__*/_react.default.createElement(_data_view_context.DataViewContext.Provider, {
      value: dataViewContextValue
    }, /*#__PURE__*/_react.default.createElement(_latest_vulnerabilities_container.LatestVulnerabilitiesContainer, null))
  })));
};
exports.Vulnerabilities = Vulnerabilities;