"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupingTitle = exports.VULNERABILITIES_UNIT = exports.VULNERABILITIES_GROUPS_UNIT = exports.VULNERABILITIES = exports.SEARCH_BAR_PLACEHOLDER = exports.NULL_GROUPING_UNIT = exports.NULL_GROUPING_MESSAGES = exports.GROUPING_LABELS = exports.FILTER_OUT = exports.FILTER_IN = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_IN = exports.FILTER_IN = _i18n.i18n.translate('xpack.csp.vulnerabilities.table.filterIn', {
  defaultMessage: 'Filter in'
});
const FILTER_OUT = exports.FILTER_OUT = _i18n.i18n.translate('xpack.csp.vulnerabilities.table.filterOut', {
  defaultMessage: 'Filter out'
});
const SEARCH_BAR_PLACEHOLDER = exports.SEARCH_BAR_PLACEHOLDER = _i18n.i18n.translate('xpack.csp.vulnerabilities.searchBar.placeholder', {
  defaultMessage: 'Search vulnerabilities (eg. vulnerability.severity : "CRITICAL" )'
});
const VULNERABILITIES = exports.VULNERABILITIES = _i18n.i18n.translate('xpack.csp.vulnerabilities', {
  defaultMessage: 'Vulnerabilities'
});
const VULNERABILITIES_UNIT = totalCount => _i18n.i18n.translate('xpack.csp.vulnerabilities.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {vulnerability} other {vulnerabilities}}`
});
exports.VULNERABILITIES_UNIT = VULNERABILITIES_UNIT;
const VULNERABILITIES_GROUPS_UNIT = (totalCount, selectedGroup, hasNullGroup) => {
  const groupCount = hasNullGroup ? totalCount - 1 : totalCount;
  switch (selectedGroup) {
    case _constants.VULNERABILITY_GROUPING_OPTIONS.RESOURCE_NAME:
      return _i18n.i18n.translate('xpack.csp.vulnerabilities.groupUnit.resource', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {resource} other {resources}}`
      });
    case _constants.VULNERABILITY_GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME:
      return _i18n.i18n.translate('xpack.csp.vulnerabilities.groupUnit.cloudAccount', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {cloud account} other {cloud accounts}}`
      });
    case _constants.VULNERABILITY_GROUPING_OPTIONS.CVE:
      return _i18n.i18n.translate('xpack.csp.vulnerabilities.groupUnit.cve', {
        values: {
          groupCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {CVE} other {CVEs}}`
      });
    default:
      return _i18n.i18n.translate('xpack.csp.vulnerabilities.groupUnit', {
        values: {
          groupCount: totalCount
        },
        defaultMessage: `{groupCount} {groupCount, plural, =1 {group} other {groups}}`
      });
  }
};
exports.VULNERABILITIES_GROUPS_UNIT = VULNERABILITIES_GROUPS_UNIT;
const NULL_GROUPING_UNIT = exports.NULL_GROUPING_UNIT = _i18n.i18n.translate('xpack.csp.vulnerabilities.grouping.nullGroupUnit', {
  defaultMessage: 'vulnerabilities'
});
const NULL_GROUPING_MESSAGES = exports.NULL_GROUPING_MESSAGES = {
  RESOURCE_NAME: _i18n.i18n.translate('xpack.csp.vulnerabilities.grouping.resource.nullGroupTitle', {
    defaultMessage: 'No resource'
  }),
  CLOUD_ACCOUNT_NAME: _i18n.i18n.translate('xpack.csp.vulnerabilities.grouping.cloudAccount.nullGroupTitle', {
    defaultMessage: 'No cloud account'
  }),
  DEFAULT: _i18n.i18n.translate('xpack.csp.vulnerabilities.grouping.default.nullGroupTitle', {
    defaultMessage: 'No grouping'
  })
};
const GROUPING_LABELS = exports.GROUPING_LABELS = {
  RESOURCE_NAME: _i18n.i18n.translate('xpack.csp.vulnerabilities.groupBy.resource', {
    defaultMessage: 'Resource'
  }),
  CLOUD_ACCOUNT_NAME: _i18n.i18n.translate('xpack.csp.vulnerabilities.groupBy.cloudAccount', {
    defaultMessage: 'Cloud account'
  })
};
const groupingTitle = exports.groupingTitle = _i18n.i18n.translate('xpack.csp.vulnerabilities.groupBy', {
  defaultMessage: 'Group vulnerabilities by'
});