"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultQuery = exports.defaultGroupingOptions = exports.defaultColumns = void 0;
var _translations = require("./translations");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultGroupingOptions = exports.defaultGroupingOptions = [{
  label: _translations.GROUPING_LABELS.RESOURCE_NAME,
  key: _constants.VULNERABILITY_GROUPING_OPTIONS.RESOURCE_NAME
}, {
  label: _translations.GROUPING_LABELS.CLOUD_ACCOUNT_NAME,
  key: _constants.VULNERABILITY_GROUPING_OPTIONS.CLOUD_ACCOUNT_NAME
}, {
  label: 'CVE',
  key: _constants.VULNERABILITY_GROUPING_OPTIONS.CVE
}];
const getDefaultQuery = ({
  query,
  filters
}) => ({
  query,
  filters,
  sort: [[_constants.VULNERABILITY_FIELDS.SEVERITY, 'asc'], [_constants.VULNERABILITY_FIELDS.SCORE_BASE, 'desc']]
});
exports.getDefaultQuery = getDefaultQuery;
const defaultColumns = exports.defaultColumns = [{
  id: _constants.VULNERABILITY_FIELDS.VULNERABILITY_ID,
  width: 130
}, {
  id: _constants.VULNERABILITY_FIELDS.SCORE_BASE,
  width: 80
}, {
  id: _constants.VULNERABILITY_FIELDS.RESOURCE_NAME
}, {
  id: _constants.VULNERABILITY_FIELDS.RESOURCE_ID
}, {
  id: _constants.VULNERABILITY_FIELDS.SEVERITY,
  width: 100
}, {
  id: _constants.VULNERABILITY_FIELDS.PACKAGE_NAME
}, {
  id: _constants.VULNERABILITY_FIELDS.PACKAGE_VERSION
}, {
  id: _constants.VULNERABILITY_FIELDS.PACKAGE_FIXED_VERSION
}];